/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import teamroots.embers.particle.IEmberParticle;
import teamroots.embers.util.Misc;

public class ParticleVapor
extends Particle
implements IEmberParticle {
    public float colorR = 0.0f;
    public float colorG = 0.0f;
    public float colorB = 0.0f;
    public float minScale = 0.0f;
    public float maxScale = 0.0f;
    public float initAlpha = 0.0f;
    public ResourceLocation texture = new ResourceLocation("embers:entity/particle_smoke");

    public ParticleVapor(World worldIn, double x, double y, double z, double vx, double vy, double vz, float r, float g, float b, float a, float scaleMin, float scaleMax, int lifetime) {
        super(worldIn, x, y, z, 0.0, 0.0, 0.0);
        this.colorR = r;
        this.colorG = g;
        this.colorB = b;
        if ((double)this.colorR > 1.0) {
            this.colorR /= 255.0f;
        }
        if ((double)this.colorG > 1.0) {
            this.colorG /= 255.0f;
        }
        if ((double)this.colorB > 1.0) {
            this.colorB /= 255.0f;
        }
        this.setRBGColorF(this.colorR, this.colorG, this.colorB);
        this.particleMaxAge = (int)((float)lifetime * 0.5f);
        this.particleScale = scaleMin;
        this.minScale = scaleMin;
        this.maxScale = scaleMax;
        this.motionX = vx * 2.0;
        this.motionY = vy * 2.0;
        this.motionZ = vz * 2.0;
        this.canCollide = false;
        this.initAlpha = a;
        this.particleAngle = this.rand.nextFloat() * 2.0f * (float)Math.PI;
        TextureAtlasSprite sprite = Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(this.texture.toString());
        this.setParticleTexture(sprite);
    }

    public int getBrightnessForRender(float pTicks) {
        return 255;
    }

    public boolean shouldDisableDepth() {
        return true;
    }

    public int getFXLayer() {
        return 1;
    }

    public void onUpdate() {
        super.onUpdate();
        if (Misc.random.nextInt(6) == 0) {
            ++this.particleAge;
        }
        float lifeCoeff = (float)this.particleAge / (float)this.particleMaxAge;
        float dScale = (this.maxScale - this.minScale) / 2.0f;
        this.particleScale = this.minScale + dScale + dScale * (float)Math.sin((double)lifeCoeff * Math.PI);
        this.particleAlpha = this.initAlpha * (1.0f - lifeCoeff);
        this.prevParticleAngle = this.particleAngle;
        if (this.particleAge >= this.particleMaxAge) {
            this.setRBGColorF(0.0f, 0.0f, 0.0f);
        }
        this.particleAngle += 1.0f;
    }

    @Override
    public boolean alive() {
        return this.particleAge < this.particleMaxAge;
    }

    @Override
    public boolean isAdditive() {
        return true;
    }

    @Override
    public boolean renderThroughBlocks() {
        return false;
    }
}

