/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import teamroots.embers.EventManager;
import teamroots.embers.config.ConfigClient;
import teamroots.embers.particle.IEmberParticle;
import teamroots.embers.util.Misc;

public class ParticleTyrfing
extends Particle
implements IEmberParticle {
    public float colorR = 0.0f;
    public float colorG = 0.0f;
    public float colorB = 0.0f;
    public float initScale = 0.0f;
    public int phase = Misc.random.nextInt(360);
    public ResourceLocation texture = new ResourceLocation("embers:entity/particle_mote");

    public ParticleTyrfing(World worldIn, double x, double y, double z, double vx, double vy, double vz, float scale, int lifetime) {
        super(worldIn, x, y, z, 0.0, 0.0, 0.0);
        float timerSine = ((float)Math.sin(8.0 * Math.toRadians(EventManager.ticks % 360)) + 1.0f) / 2.0f;
        this.particleRed = 0.25f * timerSine;
        this.particleGreen = 0.0625f;
        this.particleBlue = 0.125f + 0.125f * timerSine;
        this.setRBGColorF(this.particleRed, this.particleGreen, this.particleBlue);
        this.particleMaxAge = lifetime;
        this.particleScale = scale;
        this.initScale = scale;
        this.motionX = vx;
        this.motionY = vy;
        this.motionZ = vz;
        this.phase = Misc.random.nextInt(360);
        this.particleAngle = (float)Math.PI * 2;
        TextureAtlasSprite sprite = Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(this.texture.toString());
        this.setParticleTexture(sprite);
        this.canCollide = ConfigClient.enableParticleCollisions;
    }

    public int getBrightnessForRender(float pTicks) {
        return 255;
    }

    public boolean shouldDisableDepth() {
        return true;
    }

    public int getFXLayer() {
        return 1;
    }

    public void onUpdate() {
        super.onUpdate();
        if (Misc.random.nextInt(6) == 0) {
            ++this.particleAge;
        }
        float lifeCoeff = (float)this.particleAge / (float)this.particleMaxAge;
        this.particleScale = this.initScale - this.initScale * lifeCoeff;
        this.particleAlpha = 1.0f - lifeCoeff;
        this.prevParticleAngle = this.particleAngle;
        float timerSine = ((float)Math.sin(8.0 * Math.toRadians(EventManager.ticks % 360 + this.phase)) + 1.0f) / 2.0f;
        this.particleRed = 0.25f * timerSine;
        this.particleGreen = 0.0625f;
        this.particleBlue = 0.125f + 0.125f * timerSine;
        this.particleAngle += 1.0f;
    }

    @Override
    public boolean alive() {
        return this.particleAge < this.particleMaxAge;
    }

    @Override
    public boolean isAdditive() {
        return false;
    }

    @Override
    public boolean renderThroughBlocks() {
        return false;
    }
}

