/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.particle.ParticleUtil;

public class MessagePlayerJetFX
implements IMessage {
    public static Random random = new Random();
    public UUID id = null;

    public MessagePlayerJetFX() {
    }

    public MessagePlayerJetFX(UUID id) {
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
    }

    public static class MessageHolder
    implements IMessageHandler<MessagePlayerJetFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessagePlayerJetFX message, MessageContext ctx) {
            WorldClient world = Minecraft.getMinecraft().world;
            Minecraft.getMinecraft().addScheduledTask(() -> MessageHolder.lambda$onMessage$0((World)world, message));
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$0(World world, MessagePlayerJetFX message) {
            EntityPlayer p = world.getPlayerEntityByUUID(message.id);
            if (p != null) {
                for (int i = 0; i < 40; ++i) {
                    ParticleUtil.spawnParticleSmoke(world, (float)p.posX - (float)p.motionX - (float)p.getLookVec().x * 0.5f, (float)p.posY + p.height / 4.0f, (float)p.posZ - (float)p.motionZ - (float)p.getLookVec().z * 0.5f, -((float)p.motionX) + 0.25f * (random.nextFloat() - 0.5f), -((float)p.motionY) + 0.25f * (random.nextFloat() - 0.5f), -((float)p.motionZ) + 0.25f * (random.nextFloat() - 0.5f), 80.0f, 80.0f, 80.0f, 0.25f + 0.25f * random.nextFloat(), 4.0f + random.nextFloat() * 20.0f, 80);
                }
            }
        }
    }
}

