/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.SoundManager;
import teamroots.embers.particle.ParticleUtil;

public class MessageEmberSizedBurstFX
implements IMessage {
    public static Random random = new Random();
    public double posX = 0.0;
    public double posY = 0.0;
    public double posZ = 0.0;
    public double value = 0.0;
    public int packedColor;

    public MessageEmberSizedBurstFX() {
    }

    public MessageEmberSizedBurstFX(double x, double y, double z, double value, int packedColor) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.value = value;
        this.packedColor = packedColor;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.value = buf.readDouble();
        this.packedColor = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.value);
        buf.writeInt(this.packedColor);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageEmberSizedBurstFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageEmberSizedBurstFX message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.getMinecraft().addScheduledTask(() -> {
                    Color color = new Color(message.packedColor);
                    WorldClient world = Minecraft.getMinecraft().world;
                    world.playSound(message.posX, message.posY, message.posZ, message.value > 7.0 ? SoundManager.FIREBALL_BIG_HIT : SoundManager.FIREBALL_HIT, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
                    for (int k = 0; k < 80; ++k) {
                        ParticleUtil.spawnParticleGlow((World)world, (float)message.posX, (float)message.posY, (float)message.posZ, (float)message.value / 3.5f * 0.125f * (random.nextFloat() - 0.5f), (float)message.value / 3.5f * 0.125f * (random.nextFloat() - 0.5f), (float)message.value / 3.5f * 0.125f * (random.nextFloat() - 0.5f), color.getRed(), color.getGreen(), color.getBlue(), 1.0f, (float)message.value, 24);
                    }
                });
            }
            return null;
        }
    }
}

