/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;

public class ModelGolem
extends ModelBase {
    ModelRenderer legL;
    ModelRenderer legR;
    ModelRenderer body1;
    ModelRenderer body2;
    ModelRenderer armR;
    ModelRenderer fistR;
    ModelRenderer armL;
    ModelRenderer fistL;
    ModelRenderer head;

    public ModelGolem() {
        this.textureWidth = 64;
        this.textureHeight = 64;
        this.legL = new ModelRenderer((ModelBase)this, 0, 0);
        this.legL.addBox(-2.0f, 0.0f, -2.0f, 4, 10, 4);
        this.legL.setRotationPoint(2.0f, 14.0f, 0.0f);
        this.legL.setTextureSize(64, 64);
        this.legL.mirror = true;
        this.setRotation(this.legL, 0.0f, 0.0f, 0.0f);
        this.legR = new ModelRenderer((ModelBase)this, 0, 0);
        this.legR.addBox(-2.0f, 0.0f, -2.0f, 4, 10, 4);
        this.legR.setRotationPoint(-2.0f, 14.0f, 0.0f);
        this.legR.setTextureSize(64, 64);
        this.legR.mirror = true;
        this.setRotation(this.legR, 0.0f, 0.0f, 0.0f);
        this.body1 = new ModelRenderer((ModelBase)this, 16, 16);
        this.body1.addBox(-4.0f, 0.0f, -2.0f, 8, 4, 4);
        this.body1.setRotationPoint(0.0f, 10.0f, 0.0f);
        this.body1.setTextureSize(64, 64);
        this.body1.mirror = true;
        this.setRotation(this.body1, 0.0f, 0.0f, 0.0f);
        this.body2 = new ModelRenderer((ModelBase)this, 16, 0);
        this.body2.addBox(-4.5f, 0.0f, -3.0f, 9, 8, 6);
        this.body2.setRotationPoint(0.0f, 2.0f, 0.0f);
        this.body2.setTextureSize(64, 64);
        this.body2.mirror = true;
        this.setRotation(this.body2, 0.0f, 0.0f, 0.0f);
        this.armR = new ModelRenderer((ModelBase)this, 48, 0);
        this.armR.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.armR.setRotationPoint(-4.5f, 2.013333f, 0.0f);
        this.armR.setTextureSize(64, 64);
        this.armR.mirror = true;
        this.setRotation(this.armR, 0.0f, 0.0f, 0.3926991f);
        this.fistR = new ModelRenderer((ModelBase)this, 0, 32);
        this.fistR.addBox(-2.0f, 12.0f, -2.5f, 5, 5, 5);
        this.fistR.setRotationPoint(-4.5f, 2.013333f, 0.0f);
        this.fistR.setTextureSize(64, 64);
        this.fistR.mirror = true;
        this.setRotation(this.fistR, 0.0f, 0.0f, 0.3926991f);
        this.armL = new ModelRenderer((ModelBase)this, 48, 0);
        this.armL.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.armL.setRotationPoint(4.5f, 2.013333f, 0.0f);
        this.armL.setTextureSize(64, 64);
        this.armL.mirror = true;
        this.setRotation(this.armL, 0.0f, 0.0f, -0.3926991f);
        this.fistL = new ModelRenderer((ModelBase)this, 0, 32);
        this.fistL.addBox(-3.0f, 12.0f, -2.5f, 5, 5, 5);
        this.fistL.setRotationPoint(4.5f, 2.013333f, 0.0f);
        this.fistL.setTextureSize(64, 64);
        this.fistL.mirror = false;
        this.setRotation(this.fistL, 0.0f, 0.0f, -0.3926991f);
        this.head = new ModelRenderer((ModelBase)this, 32, 32);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.head.setRotationPoint(0.0f, 2.0f, 0.0f);
        this.head.setTextureSize(64, 64);
        this.head.mirror = true;
        this.setRotation(this.head, 0.0f, 0.0f, 0.0f);
    }

    public void render(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.pushMatrix();
        super.render(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.legL.render(scale);
        this.legR.render(scale);
        this.body1.render(scale);
        this.body2.render(scale);
        this.armR.render(scale);
        this.fistR.render(scale);
        this.armL.render(scale);
        this.fistL.render(scale);
        this.head.render(scale);
        GlStateManager.popMatrix();
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.legR.rotateAngleX = (float)Math.toRadians((double)(180.0f * (float)Math.sin((double)limbSwing * 0.5) * limbSwingAmount) * 0.5);
        this.legL.rotateAngleX = -((float)Math.toRadians((double)(180.0f * (float)Math.sin((double)limbSwing * 0.5) * limbSwingAmount) * 0.5));
        this.armL.rotateAngleX = (float)Math.toRadians((double)(180.0f * (float)Math.sin((double)limbSwing * 0.5) * limbSwingAmount) * 0.5);
        this.armR.rotateAngleX = -((float)Math.toRadians((double)(180.0f * (float)Math.sin((double)limbSwing * 0.5) * limbSwingAmount) * 0.5));
        this.fistL.rotateAngleX = (float)Math.toRadians((double)(180.0f * (float)Math.sin((double)limbSwing * 0.5) * limbSwingAmount) * 0.5);
        this.fistR.rotateAngleX = -((float)Math.toRadians((double)(180.0f * (float)Math.sin((double)limbSwing * 0.5) * limbSwingAmount) * 0.5));
    }
}

