/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;

public class ModelArmorBase
extends ModelBiped {
    public EntityEquipmentSlot slot;
    public double velocity = 0.0;
    float pastPartialTicks = 0.0f;
    public float armorScale = 1.05f;
    ModelRenderer head;
    ModelRenderer cape;
    ModelRenderer chest;
    ModelRenderer armR;
    ModelRenderer armL;
    ModelRenderer legR;
    ModelRenderer legL;
    ModelRenderer legsTop;
    ModelRenderer bootR;
    ModelRenderer bootL;

    public ModelArmorBase getModelForSlot(EntityEquipmentSlot slot) {
        this.slot = slot;
        return this;
    }

    public ModelArmorBase(EntityEquipmentSlot slot) {
        super(0.0f, 1.0f, 64, 64);
        this.textureHeight = 64;
        this.textureWidth = 64;
        this.isChild = false;
        this.slot = slot;
        this.head = new ModelRenderer((ModelBase)this);
        this.chest = new ModelRenderer((ModelBase)this);
        this.armR = new ModelRenderer((ModelBase)this);
        this.armL = new ModelRenderer((ModelBase)this);
        this.legR = new ModelRenderer((ModelBase)this);
        this.legL = new ModelRenderer((ModelBase)this);
        this.legsTop = new ModelRenderer((ModelBase)this);
        this.bootR = new ModelRenderer((ModelBase)this);
        this.bootL = new ModelRenderer((ModelBase)this);
    }

    public void setRotationAngles(float p_78087_1_, float p_78087_2_, float p_78087_3_, float p_78087_4_, float p_78087_5_, float p_78087_6_, Entity entityIn) {
        if (entityIn instanceof EntityArmorStand) {
            EntityArmorStand entityarmorstand = (EntityArmorStand)entityIn;
            this.bipedHead.rotateAngleX = (float)Math.PI / 180 * entityarmorstand.getHeadRotation().getX();
            this.bipedHead.rotateAngleY = (float)Math.PI / 180 * entityarmorstand.getHeadRotation().getY();
            this.bipedHead.rotateAngleZ = (float)Math.PI / 180 * entityarmorstand.getHeadRotation().getZ();
            this.bipedHead.setRotationPoint(0.0f, 1.0f, 0.0f);
            this.bipedBody.rotateAngleX = (float)Math.PI / 180 * entityarmorstand.getBodyRotation().getX();
            this.bipedBody.rotateAngleY = (float)Math.PI / 180 * entityarmorstand.getBodyRotation().getY();
            this.bipedBody.rotateAngleZ = (float)Math.PI / 180 * entityarmorstand.getBodyRotation().getZ();
            this.bipedLeftArm.rotateAngleX = (float)Math.PI / 180 * entityarmorstand.getLeftArmRotation().getX();
            this.bipedLeftArm.rotateAngleY = (float)Math.PI / 180 * entityarmorstand.getLeftArmRotation().getY();
            this.bipedLeftArm.rotateAngleZ = (float)Math.PI / 180 * entityarmorstand.getLeftArmRotation().getZ();
            this.bipedRightArm.rotateAngleX = (float)Math.PI / 180 * entityarmorstand.getRightArmRotation().getX();
            this.bipedRightArm.rotateAngleY = (float)Math.PI / 180 * entityarmorstand.getRightArmRotation().getY();
            this.bipedRightArm.rotateAngleZ = (float)Math.PI / 180 * entityarmorstand.getRightArmRotation().getZ();
            this.bipedLeftLeg.rotateAngleX = (float)Math.PI / 180 * entityarmorstand.getLeftLegRotation().getX();
            this.bipedLeftLeg.rotateAngleY = (float)Math.PI / 180 * entityarmorstand.getLeftLegRotation().getY();
            this.bipedLeftLeg.rotateAngleZ = (float)Math.PI / 180 * entityarmorstand.getLeftLegRotation().getZ();
            this.bipedLeftLeg.setRotationPoint(1.9f, 11.0f, 0.0f);
            this.bipedRightLeg.rotateAngleX = (float)Math.PI / 180 * entityarmorstand.getRightLegRotation().getX();
            this.bipedRightLeg.rotateAngleY = (float)Math.PI / 180 * entityarmorstand.getRightLegRotation().getY();
            this.bipedRightLeg.rotateAngleZ = (float)Math.PI / 180 * entityarmorstand.getRightLegRotation().getZ();
            this.bipedRightLeg.setRotationPoint(-1.9f, 11.0f, 0.0f);
            ModelArmorBase.copyModelAngles((ModelRenderer)this.bipedHead, (ModelRenderer)this.bipedHeadwear);
        } else {
            super.setRotationAngles(p_78087_1_, p_78087_2_, p_78087_3_, p_78087_4_, p_78087_5_, p_78087_6_, entityIn);
        }
    }

    public void render(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float netHeadPitch, float scale) {
        float f;
        this.prepareForRender(entity);
        this.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, netHeadPitch, scale, entity);
        this.setHeadRotation();
        this.setChestRotation(entity);
        this.setLegsRotation();
        this.setBootRotation();
        GlStateManager.pushMatrix();
        this.head.showModel = this.slot == EntityEquipmentSlot.HEAD;
        this.chest.showModel = this.slot == EntityEquipmentSlot.CHEST;
        this.armR.showModel = this.slot == EntityEquipmentSlot.CHEST;
        this.armL.showModel = this.slot == EntityEquipmentSlot.CHEST;
        this.legR.showModel = this.slot == EntityEquipmentSlot.LEGS;
        this.legL.showModel = this.slot == EntityEquipmentSlot.LEGS;
        this.legsTop.showModel = this.slot == EntityEquipmentSlot.LEGS;
        this.bootR.showModel = this.slot == EntityEquipmentSlot.FEET;
        boolean bl = this.bootL.showModel = this.slot == EntityEquipmentSlot.FEET;
        if (this.isChild) {
            f = 2.0f;
            GlStateManager.scale((float)(1.5f / f), (float)(1.5f / f), (float)(1.5f / f));
            GlStateManager.translate((float)0.0f, (float)(16.0f * scale), (float)0.0f);
            this.renderHead(scale * this.armorScale);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.scale((float)(1.0f / f), (float)(1.0f / f), (float)(1.0f / f));
            GlStateManager.translate((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.renderPartsMinusHead(scale * this.armorScale);
            GlStateManager.translate((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.renderLegs(scale * this.armorScale);
        } else {
            if (entity.isSneaking()) {
                GlStateManager.translate((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.renderParts(scale * this.armorScale);
            GlStateManager.translate((float)0.0f, (float)(-2.0f * scale), (float)0.0f);
            this.renderArms(scale * this.armorScale);
            GlStateManager.translate((float)0.0f, (float)(2.0f * scale), (float)0.0f);
            GlStateManager.translate((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.renderLegs(scale * this.armorScale);
        }
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        if (this.cape != null) {
            this.setCapeRotation(entity);
            boolean bl2 = this.cape.showModel = this.slot == EntityEquipmentSlot.CHEST;
            if (this.cape.childModels.size() == 10 && this.cape.showModel) {
                ItemStack stack;
                for (int i = 1; i < 8; ++i) {
                    ((ModelRenderer)this.cape.childModels.get((int)(i + 2))).showModel = false;
                }
                if (entity instanceof EntityLivingBase && (stack = ((EntityLivingBase)entity).getItemStackFromSlot(EntityEquipmentSlot.CHEST)).hasTagCompound()) {
                    for (int i = 1; i < 8; ++i) {
                        ((ModelRenderer)this.cape.childModels.get((int)(i + 2))).showModel = this.slot == EntityEquipmentSlot.CHEST && stack.getTagCompound().hasKey("gem" + i);
                    }
                }
            }
            if (this.isChild) {
                f = 2.0f;
                GlStateManager.scale((float)(1.0f / f), (float)(1.0f / f), (float)(1.0f / f));
                GlStateManager.translate((float)0.0f, (float)(24.0f * scale), (float)0.0f);
                this.renderCape(scale * this.armorScale);
            } else {
                if (entity.isSneaking()) {
                    GlStateManager.translate((float)0.0f, (float)0.2f, (float)0.0f);
                }
                this.renderCape(scale * this.armorScale);
            }
        }
        GlStateManager.popMatrix();
    }

    public void setCapeRotation(Entity e) {
        double hComp = Math.atan((double)6.28f * Math.sqrt(e.motionX * e.motionX + e.motionZ * e.motionZ) / (double)0.4f);
        double yComp = (Math.max(-0.8, Math.min(0.8, -e.motionY)) + 0.4) / 0.6;
        this.velocity = this.velocity * 0.5 + (hComp * 0.5 + yComp * 0.5) * 0.5;
        this.cape.rotationPointX = this.bipedBody.rotationPointX;
        this.cape.rotationPointY = this.bipedBody.rotationPointY - 1.0f;
        this.cape.rotationPointZ = this.bipedBody.rotationPointZ;
        ModelArmorBase.setRotation(this.cape, this.bipedBody.rotateAngleX + (float)Math.toRadians(80.0 * this.velocity), this.bipedBody.rotateAngleY, this.bipedBody.rotateAngleZ);
    }

    public void renderCape(float scale) {
        this.cape.render(scale);
    }

    public void renderHead(float scale) {
        this.head.render(scale);
    }

    public void renderParts(float scale) {
        this.head.render(scale);
        this.chest.render(scale);
        this.legsTop.render(scale);
    }

    public void renderArms(float scale) {
        this.armR.render(scale);
        this.armL.render(scale);
    }

    public void renderPartsMinusHead(float scale) {
        this.chest.render(scale);
        this.legsTop.render(scale);
    }

    public void renderLegs(float scale) {
        this.legR.render(scale);
        this.legL.render(scale);
        this.bootR.render(scale);
        this.bootL.render(scale);
    }

    public void setHeadRotation() {
        this.head.rotationPointX = this.bipedHead.rotationPointX;
        this.head.rotationPointY = this.bipedHead.rotationPointY;
        this.head.rotationPointZ = this.bipedHead.rotationPointZ;
        ModelArmorBase.setRotation(this.head, this.bipedHead.rotateAngleX, this.bipedHead.rotateAngleY, this.bipedHead.rotateAngleZ);
    }

    public void setChestRotation(Entity e) {
        this.chest.rotationPointX = this.bipedBody.rotationPointX;
        this.chest.rotationPointY = this.bipedBody.rotationPointY - 1.0f;
        this.chest.rotationPointZ = this.bipedBody.rotationPointZ;
        this.legsTop.rotationPointX = this.bipedBody.rotationPointX;
        this.legsTop.rotationPointY = this.bipedBody.rotationPointY - 1.0f;
        this.legsTop.rotationPointZ = this.bipedBody.rotationPointZ;
        this.armR.rotationPointX = this.bipedRightArm.rotationPointX;
        this.armR.rotationPointY = this.bipedRightArm.rotationPointY;
        this.armR.rotationPointZ = this.bipedRightArm.rotationPointZ;
        this.armL.rotationPointX = this.bipedLeftArm.rotationPointX;
        this.armL.rotationPointY = this.bipedLeftArm.rotationPointY;
        this.armL.rotationPointZ = this.bipedLeftArm.rotationPointZ;
        ModelArmorBase.setRotation(this.chest, this.bipedBody.rotateAngleX, this.bipedBody.rotateAngleY, this.bipedBody.rotateAngleZ);
        ModelArmorBase.setRotation(this.legsTop, this.bipedBody.rotateAngleX, this.bipedBody.rotateAngleY, this.bipedBody.rotateAngleZ);
        ModelArmorBase.setRotation(this.armR, this.bipedRightArm.rotateAngleX, this.bipedRightArm.rotateAngleY, this.bipedRightArm.rotateAngleZ);
        ModelArmorBase.setRotation(this.armL, this.bipedLeftArm.rotateAngleX, this.bipedLeftArm.rotateAngleY, this.bipedLeftArm.rotateAngleZ);
    }

    public void setLegsRotation() {
        this.legR.rotationPointX = this.bipedRightLeg.rotationPointX + 2.0f;
        this.legR.rotationPointY = this.bipedRightLeg.rotationPointY - 12.0f;
        this.legR.rotationPointZ = this.bipedRightLeg.rotationPointZ;
        this.legL.rotationPointX = this.bipedLeftLeg.rotationPointX - 2.0f;
        this.legL.rotationPointY = this.bipedLeftLeg.rotationPointY - 12.0f;
        this.legL.rotationPointZ = this.bipedLeftLeg.rotationPointZ;
        this.legL.offsetY = this.bipedLeftLeg.offsetY - 0.75f;
        this.legR.offsetY = this.bipedRightLeg.offsetY - 0.75f;
        ModelArmorBase.setRotation(this.legR, this.bipedRightLeg.rotateAngleX, this.bipedRightLeg.rotateAngleY, this.bipedRightLeg.rotateAngleZ);
        ModelArmorBase.setRotation(this.legL, this.bipedLeftLeg.rotateAngleX, this.bipedLeftLeg.rotateAngleY, this.bipedLeftLeg.rotateAngleZ);
    }

    public void setBootRotation() {
        this.bootR.rotationPointX = this.bipedRightLeg.rotationPointX + 2.0f;
        this.bootR.rotationPointY = this.bipedRightLeg.rotationPointY - 12.0f;
        this.bootR.rotationPointZ = this.bipedRightLeg.rotationPointZ;
        this.bootL.rotationPointX = this.bipedLeftLeg.rotationPointX - 2.0f;
        this.bootL.rotationPointY = this.bipedLeftLeg.rotationPointY - 12.0f;
        this.bootL.rotationPointZ = this.bipedLeftLeg.rotationPointZ;
        this.bootL.offsetY = this.bipedLeftLeg.offsetY - 0.75f;
        this.bootR.offsetY = this.bipedRightLeg.offsetY - 0.75f;
        ModelArmorBase.setRotation(this.bootR, this.bipedRightLeg.rotateAngleX, this.bipedRightLeg.rotateAngleY, this.bipedRightLeg.rotateAngleZ);
        ModelArmorBase.setRotation(this.bootL, this.bipedLeftLeg.rotateAngleX, this.bipedLeftLeg.rotateAngleY, this.bipedLeftLeg.rotateAngleZ);
    }

    public void prepareForRender(Entity entity) {
        EntityLivingBase living = (EntityLivingBase)entity;
        this.isSneak = living != null && living.isSneaking();
        this.isChild = living != null && living.isChild();
        this.isRiding = living.isRiding();
        this.swingProgress = living.getSwingProgress(0.0f);
        if (living != null) {
            ModelBiped.ArmPose mainPose = ModelBiped.ArmPose.EMPTY;
            ModelBiped.ArmPose offPose = ModelBiped.ArmPose.EMPTY;
            if (!living.getHeldItemMainhand().isEmpty()) {
                mainPose = ModelBiped.ArmPose.ITEM;
                if (living.getItemInUseCount() > 0) {
                    EnumAction enumaction = living.getHeldItemMainhand().getItemUseAction();
                    if (enumaction == EnumAction.BLOCK) {
                        mainPose = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction == EnumAction.BOW) {
                        mainPose = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (!living.getHeldItemOffhand().isEmpty()) {
                EnumAction enumaction1;
                offPose = ModelBiped.ArmPose.ITEM;
                if (living.getItemInUseCount() > 0 && (enumaction1 = living.getHeldItemOffhand().getItemUseAction()) == EnumAction.BLOCK) {
                    offPose = ModelBiped.ArmPose.BLOCK;
                }
            }
            if (living.getPrimaryHand() == EnumHandSide.RIGHT) {
                this.rightArmPose = mainPose;
                this.leftArmPose = offPose;
            } else {
                this.rightArmPose = offPose;
                this.leftArmPose = mainPose;
            }
        }
    }

    public static void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }
}

