/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageSuperheatFX;
import teamroots.embers.util.EmberInventoryUtil;

public class ModifierSuperheater
extends ModifierBase {
    public ModifierSuperheater() {
        super(ModifierBase.EnumType.TOOL, "superheater", 2.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.HarvestDropsEvent event) {
        ItemStack s;
        if (event.getHarvester() instanceof EntityPlayer && !event.getHarvester().getHeldItem(EnumHand.MAIN_HAND).isEmpty() && ItemModUtil.hasHeat(s = event.getHarvester().getHeldItem(EnumHand.MAIN_HAND)) && ItemModUtil.getModifierLevel(s, EmbersAPI.SUPERHEATER) > 0 && EmberInventoryUtil.getEmberTotal(event.getHarvester()) >= this.cost) {
            if (!event.getWorld().isRemote) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSuperheatFX((double)event.getPos().getX() + 0.5, (double)event.getPos().getY() + 0.5, (double)event.getPos().getZ() + 0.5));
            }
            event.getWorld().playSound(null, event.getPos(), SoundManager.FIREBALL_HIT, SoundCategory.PLAYERS, 0.5f, event.getWorld().rand.nextFloat() * 0.5f + 0.2f);
            EmberInventoryUtil.removeEmber(event.getHarvester(), this.cost);
            List stacks = event.getDrops();
            for (int i = 0; i < stacks.size(); ++i) {
                ItemStack stack = FurnaceRecipes.instance().getSmeltingResult((ItemStack)stacks.get(i)).copy();
                if (stack.isEmpty()) continue;
                stacks.add(stack);
                stacks.set(i, ItemStack.EMPTY);
            }
        }
    }

    private double getBurnBonus(double resonance) {
        if (resonance > 1.0) {
            return 1.0 + (resonance - 1.0) * 0.5;
        }
        return resonance;
    }

    private double getDamageBonus(double resonance) {
        if (resonance > 1.0) {
            return 1.0 + (resonance - 1.0) * 1.0;
        }
        return resonance;
    }

    @SubscribeEvent
    public void onHit(LivingHurtEvent event) {
        int level;
        EntityPlayer damager;
        ItemStack s;
        if (event.getSource().getTrueSource() instanceof EntityPlayer && !(s = (damager = (EntityPlayer)event.getSource().getTrueSource()).getHeldItemMainhand()).isEmpty() && ItemModUtil.hasHeat(s) && (level = ItemModUtil.getModifierLevel(s, EmbersAPI.SUPERHEATER)) > 0 && EmberInventoryUtil.getEmberTotal(damager) >= this.cost) {
            double resonance = EmbersAPI.getEmberEfficiency(s);
            int burnTime = (int)(Math.pow(2.0, level - 1) * 5.0 * this.getBurnBonus(resonance));
            float extraDamage = (float)((double)level * this.getDamageBonus(resonance));
            event.getEntityLiving().setFire(burnTime);
            if (!damager.world.isRemote) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSuperheatFX(event.getEntity().posX, event.getEntity().posY + (double)event.getEntity().height / 2.0, event.getEntity().posZ));
            }
            EmberInventoryUtil.removeEmber(damager, this.cost);
            event.setAmount(event.getAmount() + extraDamage);
        }
    }
}

