/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.util.EmberInventoryUtil;
import teamroots.embers.util.Misc;

public class ModifierBlastingCore
extends ModifierBase {
    private final HashSet<Entity> blastedEntities = new HashSet();

    public ModifierBlastingCore() {
        super(ModifierBase.EnumType.TOOL_OR_ARMOR, "blasting_core", 2.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private double getChanceBonus(double resonance) {
        if (resonance > 1.0) {
            return 1.0 + (resonance - 1.0) * 0.5;
        }
        return resonance;
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.BreakEvent event) {
        ItemStack s;
        int blastingLevel;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (event.getPlayer() != null && !event.getPlayer().getHeldItem(EnumHand.MAIN_HAND).isEmpty() && (blastingLevel = ItemModUtil.getModifierLevel(s = event.getPlayer().getHeldItem(EnumHand.MAIN_HAND), EmbersAPI.BLASTING_CORE)) > 0 && EmberInventoryUtil.getEmberTotal(event.getPlayer()) >= this.cost) {
            world.createExplosion((Entity)event.getPlayer(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.5f, true);
            double resonance = EmbersAPI.getEmberEfficiency(s);
            double chance = (double)blastingLevel / (double)(blastingLevel + 1) * this.getChanceBonus(resonance);
            for (BlockPos toExplode : this.getBlastCube(world, pos, event.getPlayer(), chance)) {
                IBlockState state = world.getBlockState(toExplode);
                if (!(state.getBlockHardness(world, toExplode) >= 0.0f) || !event.getPlayer().canHarvestBlock(world.getBlockState(toExplode))) continue;
                world.destroyBlock(toExplode, true);
                world.notifyBlockUpdate(toExplode, state, Blocks.AIR.getDefaultState(), 8);
            }
            EmberInventoryUtil.removeEmber(event.getPlayer(), this.cost);
        }
    }

    public Iterable<BlockPos> getBlastAdjacent(World world, BlockPos pos, EntityPlayer player, double chance) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int i = 0; i < 6; ++i) {
            EnumFacing face = EnumFacing.byIndex((int)i);
            if (!(Misc.random.nextDouble() < chance)) continue;
            posList.add(pos.offset(face));
        }
        return posList;
    }

    public Iterable<BlockPos> getBlastCube(World world, BlockPos pos, EntityPlayer player, double chance) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (EnumFacing facePrimary : EnumFacing.VALUES) {
            if (!(Misc.random.nextDouble() < chance)) continue;
            BlockPos posPrimary = pos.offset(facePrimary);
            posList.add(posPrimary);
            for (EnumFacing faceSecondary : EnumFacing.VALUES) {
                if (faceSecondary.getAxis() == facePrimary.getAxis() || !(Misc.random.nextDouble() < chance - 0.5)) continue;
                BlockPos posSecondary = posPrimary.offset(faceSecondary);
                posList.add(posSecondary);
                for (EnumFacing faceTertiary : EnumFacing.VALUES) {
                    if (faceTertiary.getAxis() == facePrimary.getAxis() || faceTertiary.getAxis() == faceSecondary.getAxis() || !(Misc.random.nextDouble() < chance - 1.0)) continue;
                    BlockPos posTertiary = posSecondary.offset(faceTertiary);
                    posList.add(posTertiary);
                }
            }
        }
        return posList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onHit(LivingHurtEvent event) {
        if (!this.blastedEntities.contains(event.getEntity()) && event.getSource().getTrueSource() != event.getEntity() && event.getSource().getImmediateSource() != event.getEntity()) {
            try {
                int blastingLevel;
                EntityPlayer damager;
                if (event.getSource().getTrueSource() instanceof EntityPlayer) {
                    int blastingLevel2;
                    damager = (EntityPlayer)event.getSource().getTrueSource();
                    this.blastedEntities.add((Entity)damager);
                    ItemStack s = damager.getHeldItemMainhand();
                    if (!s.isEmpty() && (blastingLevel2 = ItemModUtil.getModifierLevel(s, EmbersAPI.BLASTING_CORE)) > 0 && EmberInventoryUtil.getEmberTotal(damager) >= this.cost) {
                        double resonance = EmbersAPI.getEmberEfficiency(s);
                        float strength = (float)((resonance + 1.0) * (Math.atan(0.6 * (double)blastingLevel2) / Math.PI));
                        EmberInventoryUtil.removeEmber(damager, this.cost);
                        List entities = damager.world.getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB(event.getEntityLiving().posX - 4.0 * (double)strength, event.getEntityLiving().posY - 4.0 * (double)strength, event.getEntityLiving().posZ - 4.0 * (double)strength, event.getEntityLiving().posX + 4.0 * (double)strength, event.getEntityLiving().posY + 4.0 * (double)strength, event.getEntityLiving().posZ + 4.0 * (double)strength));
                        for (EntityLivingBase e : entities) {
                            if (Objects.equals(e.getUniqueID(), damager.getUniqueID())) continue;
                            e.attackEntityFrom(DamageSource.causeExplosionDamage((EntityLivingBase)damager), event.getAmount() * strength);
                            e.hurtResistantTime = 0;
                        }
                        event.getEntityLiving().world.createExplosion((Entity)event.getEntityLiving(), event.getEntityLiving().posX, event.getEntityLiving().posY + (double)event.getEntityLiving().height / 2.0, event.getEntityLiving().posZ, 0.5f, true);
                    }
                }
                if (event.getEntity() instanceof EntityPlayer && (blastingLevel = ItemModUtil.getArmorModifierLevel((EntityLivingBase)(damager = (EntityPlayer)event.getEntity()), EmbersAPI.BLASTING_CORE)) > 0 && EmberInventoryUtil.getEmberTotal(damager) >= this.cost) {
                    float strength = (float)(2.0 * (Math.atan(0.6 * (double)blastingLevel) / Math.PI));
                    EmberInventoryUtil.removeEmber(damager, this.cost);
                    List entities = damager.world.getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB(event.getEntityLiving().posX - 4.0 * (double)strength, event.getEntityLiving().posY - 4.0 * (double)strength, event.getEntityLiving().posZ - 4.0 * (double)strength, event.getEntityLiving().posX + 4.0 * (double)strength, event.getEntityLiving().posY + 4.0 * (double)strength, event.getEntityLiving().posZ + 4.0 * (double)strength));
                    for (EntityLivingBase e : entities) {
                        if (Objects.equals(e.getUniqueID(), event.getEntity().getUniqueID())) continue;
                        this.blastedEntities.add((Entity)e);
                        e.attackEntityFrom(DamageSource.causeExplosionDamage((EntityLivingBase)damager), event.getAmount() * strength * 0.25f);
                        e.knockBack(event.getEntity(), 2.0f * strength, -e.posX + damager.posX, -e.posZ + damager.posZ);
                        e.hurtResistantTime = 0;
                    }
                    event.getEntityLiving().world.createExplosion((Entity)event.getEntityLiving(), event.getEntityLiving().posX, event.getEntityLiving().posY + (double)event.getEntityLiving().height / 2.0, event.getEntityLiving().posZ, 0.5f, true);
                }
            }
            finally {
                this.blastedEntities.clear();
            }
        }
    }
}

