/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.item.ItemEmberStorage;
import teamroots.embers.power.DefaultEmberItemCapability;

public class ItemBlockCell
extends ItemBlock {
    public ItemBlockCell(Block block) {
        super(block);
        this.setHasSubtypes(true);
    }

    public ItemStack withFill(double ember) {
        ItemStack stack = new ItemStack((Item)this);
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            capability.setEmber(ember);
        }
        return stack;
    }

    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.isInCreativeTab(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            subItems.add((Object)this.withFill(this.getCapacity()));
        }
    }

    public double getCapacity() {
        return 24000.0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new DefaultEmberItemCapability(stack, this.getCapacity());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            return (capability.getEmberCapacity() - capability.getEmber()) / capability.getEmberCapacity();
        }
        return 0.0;
    }

    public void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            tooltip.add(ItemEmberStorage.formatEmber(capability.getEmber(), capability.getEmberCapacity()));
        }
    }
}

