/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item.bauble;

import baubles.api.BaubleType;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.SoundManager;
import teamroots.embers.item.bauble.BaublesUtil;
import teamroots.embers.item.bauble.ItemBaubleBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageExplosionCharmFX;

public class ItemExplosionCharm
extends ItemBaubleBase {
    public static final int COOLDOWN = 100;
    public static final int MERCY_TIME = 5;
    public static WeakHashMap<Entity, Integer> cooldownTicks = new WeakHashMap();
    public static WeakHashMap<Entity, Integer> mercyTicks = new WeakHashMap();

    public static void setCooldown(Entity entity, int ticks) {
        cooldownTicks.put(entity, ticks);
    }

    public static boolean hasCooldown(Entity entity) {
        return cooldownTicks.getOrDefault(entity, 0) > 0;
    }

    public static void setMercy(Entity entity, int ticks) {
        mercyTicks.put(entity, ticks);
    }

    public static boolean hasMercy(Entity entity) {
        return mercyTicks.getOrDefault(entity, 0) > 0;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Integer ticks;
            for (Entity entity : cooldownTicks.keySet()) {
                ticks = cooldownTicks.get(entity) - 1;
                cooldownTicks.put(entity, ticks);
            }
            for (Entity entity : mercyTicks.keySet()) {
                ticks = mercyTicks.get(entity) - 1;
                mercyTicks.put(entity, ticks);
            }
        }
    }

    public ItemExplosionCharm(String name, boolean addToTab) {
        super(name, BaubleType.CHARM, addToTab);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        if (event.getWorld().isRemote) {
            return;
        }
        Explosion explosion = event.getExplosion();
        float f3 = 4.0f;
        Vec3d explosionPos = explosion.getPosition();
        int k1 = MathHelper.floor((double)(explosionPos.x - (double)f3 - 1.0));
        int l1 = MathHelper.floor((double)(explosionPos.x + (double)f3 + 1.0));
        int i2 = MathHelper.floor((double)(explosionPos.y - (double)f3 - 1.0));
        int i1 = MathHelper.floor((double)(explosionPos.y + (double)f3 + 1.0));
        int j2 = MathHelper.floor((double)(explosionPos.z - (double)f3 - 1.0));
        int j1 = MathHelper.floor((double)(explosionPos.z + (double)f3 + 1.0));
        List entities = event.getWorld().getEntitiesWithinAABBExcludingEntity(null, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        for (Entity entity : entities) {
            NonNullList<ItemStack> stacks;
            ItemStack stack;
            if (!entity.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null) || (stack = (ItemStack)(stacks = BaublesUtil.getBaubles((IBaublesItemHandler)entity.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null), BaubleType.CHARM)).get(0)).getItem() != this || ItemExplosionCharm.hasCooldown(entity) && !ItemExplosionCharm.hasMercy(entity)) continue;
            event.getWorld().playSound(null, explosionPos.x, explosionPos.y, explosionPos.z, SoundManager.EXPLOSION_CHARM_ABSORB, SoundCategory.PLAYERS, 1.0f, 1.0f);
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageExplosionCharmFX(explosionPos.x, explosionPos.y, explosionPos.z, entity.posX, entity.posY + (double)entity.height / 2.0, entity.posZ));
            event.setCanceled(true);
            if (ItemExplosionCharm.hasCooldown(entity)) continue;
            event.getWorld().playSound(null, entity.posX, entity.posY, entity.posZ, SoundManager.EXPLOSION_CHARM_RECHARGE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            ItemExplosionCharm.setCooldown(entity, 100);
            ItemExplosionCharm.setMercy(entity, 5);
        }
    }
}

