/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item.bauble;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import teamroots.embers.SoundManager;
import teamroots.embers.item.ItemBase;

public class ItemBaubleBase
extends ItemBase
implements IBauble {
    BaubleType type = BaubleType.CHARM;

    public ItemBaubleBase(String name, BaubleType type, boolean addToTab) {
        super(name, addToTab);
        this.type = type;
        this.setMaxStackSize(1);
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return this.type;
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        player.world.playSound(null, player.posX, player.posY, player.posZ, SoundManager.BAUBLE_EQUIP, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        player.world.playSound(null, player.posX, player.posY, player.posZ, SoundManager.BAUBLE_UNEQUIP, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        ItemStack toEquip = stack.copy();
        toEquip.setCount(1);
        if (this.canEquip(toEquip, (EntityLivingBase)player)) {
            if (world.isRemote) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stackInSlot;
                if (!baubles.isItemValidForSlot(i, toEquip, (EntityLivingBase)player) || !(stackInSlot = baubles.getStackInSlot(i)).isEmpty() && !((IBauble)stackInSlot.getItem()).canUnequip(stackInSlot, (EntityLivingBase)player)) continue;
                baubles.setStackInSlot(i, toEquip);
                stack.shrink(1);
                if (!stackInSlot.isEmpty()) {
                    ((IBauble)stackInSlot.getItem()).onUnequipped(stackInSlot, (EntityLivingBase)player);
                    if (stack.isEmpty()) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stackInSlot);
                    }
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackInSlot);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }
}

