/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import teamroots.embers.SoundManager;
import teamroots.embers.api.item.IInflictorGem;
import teamroots.embers.item.ItemBase;

public class ItemInflictorGem
extends ItemBase
implements IInflictorGem {
    public ItemInflictorGem() {
        super("inflictor_gem", true);
        this.setMaxStackSize(1);
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (player.isSneaking() && stack.getItemDamage() == 1) {
            stack.setItemDamage(0);
            stack.getTagCompound().removeTag("type");
            if (player.getHealth() > 1.0f) {
                player.setHealth(Math.max(player.getHealth() - 10.0f, 1.0f));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
    }

    public void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("type")) {
            tooltip.add(I18n.format((String)"embers.tooltip.inflictor", (Object[])new Object[0]) + stack.getTagCompound().getString("type"));
        }
    }

    @Override
    public void initModel() {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName().toString() + "_empty"), new ModelResourceLocation(this.getRegistryName().toString() + "_full")});
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString() + "_empty"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString() + "_full"));
    }

    @Override
    public void attuneSource(ItemStack stack, @Nullable EntityLivingBase entity, DamageSource source) {
        String damageType = source.damageType;
        if (damageType.compareTo("mob") != 0 && damageType.compareTo("generic") != 0 && damageType.compareTo("player") != 0 && damageType.compareTo("arrow") != 0 && stack.hasTagCompound()) {
            stack.setItemDamage(1);
            stack.getTagCompound().setString("type", damageType);
            if (entity != null) {
                entity.getEntityWorld().playSound(null, entity.posX, entity.posY, entity.posZ, SoundManager.INFLICTOR_GEM, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public String getAttunedSource(ItemStack stack) {
        if (!stack.isEmpty() && stack.hasTagCompound() && stack.getTagCompound().hasKey("type")) {
            return stack.getTagCompound().getString("type");
        }
        return null;
    }

    @Override
    public float getDamageResistance(ItemStack stack, float modifier) {
        return 0.35f;
    }
}

