/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import teamroots.embers.Embers;
import teamroots.embers.api.item.IEmberChargedTool;
import teamroots.embers.item.IModeledItem;
import teamroots.embers.util.EmberInventoryUtil;

public class ItemGrandhammer
extends ItemTool
implements IModeledItem,
IEmberChargedTool {
    public static Item.ToolMaterial materialGrandhammer = EnumHelper.addToolMaterial((String)"embers:grandhammer", (int)1, (int)-1, (float)6.0f, (float)6.0f, (int)15);

    public ItemGrandhammer(String name, boolean addToTab) {
        super(materialGrandhammer, (Set)Sets.newHashSet((Object[])new Block[]{Blocks.STONE}));
        this.setTranslationKey(name);
        this.setRegistryName("embers:" + name);
        if (addToTab) {
            this.setCreativeTab(Embers.tab);
        }
        this.setHarvestLevel("pickaxe", this.toolMaterial.getHarvestLevel());
        this.setHarvestLevel("axe", this.toolMaterial.getHarvestLevel());
        this.setHarvestLevel("shovel", this.toolMaterial.getHarvestLevel());
        this.attackDamage = 10.0f;
        this.attackSpeed = -3.0f;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.hasTagCompound() && stack.getTagCompound().getInteger("cooldown") > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.hasTagCompound() && stack.getTagCompound().getInteger("cooldown") > 0) {
            return (float)stack.getTagCompound().getInteger("cooldown") / 160.0f;
        }
        return 0.0;
    }

    public float getDestroySpeed(ItemStack stack, IBlockState state) {
        if (stack.hasTagCompound() && !stack.getTagCompound().getBoolean("poweredOn")) {
            return 0.0f;
        }
        return this.efficiency;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return enchant.type != EnumEnchantmentType.BREAKABLE && enchant != Enchantments.FORTUNE && enchant != Enchantments.SILK_TOUCH && (enchant.type == EnumEnchantmentType.WEAPON || enchant.type == EnumEnchantmentType.DIGGER);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return state.getBlock().getHarvestLevel(state) < 1;
    }

    public boolean onBlockDestroyed(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase living) {
        stack.getTagCompound().setBoolean("didUse", true);
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.hasTagCompound() && newStack.hasTagCompound()) {
            return slotChanged || oldStack.getTagCompound().getBoolean("poweredOn") != newStack.getTagCompound().getBoolean("poweredOn") || newStack.getItem() != oldStack.getItem();
        }
        return slotChanged || newStack.getItem() != oldStack.getItem();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.hasTagCompound() && newStack.hasTagCompound()) {
            return oldStack.getTagCompound().getBoolean("poweredOn") != newStack.getTagCompound().getBoolean("poweredOn");
        }
        return false;
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
            stack.getTagCompound().setInteger("tickCount", 0);
            stack.getTagCompound().setBoolean("poweredOn", false);
            stack.getTagCompound().setBoolean("didUse", false);
            stack.getTagCompound().setInteger("cooldown", 0);
        } else {
            if (stack.getTagCompound().getInteger("cooldown") > 0) {
                stack.getTagCompound().setInteger("cooldown", stack.getTagCompound().getInteger("cooldown") - 1);
            }
            if (entity instanceof EntityPlayer) {
                stack.getTagCompound().setInteger("tickCount", stack.getTagCompound().getInteger("tickCount") + 1);
                if (stack.getTagCompound().getInteger("tickCount") >= 5) {
                    stack.getTagCompound().setInteger("tickCount", 0);
                    if (EmberInventoryUtil.getEmberTotal((EntityPlayer)entity) > 5.0) {
                        if (!stack.getTagCompound().getBoolean("poweredOn")) {
                            stack.getTagCompound().setBoolean("poweredOn", true);
                        }
                    } else if (stack.getTagCompound().getBoolean("poweredOn")) {
                        stack.getTagCompound().setBoolean("poweredOn", false);
                    }
                }
                if (stack.getTagCompound().getBoolean("didUse")) {
                    stack.getTagCompound().setBoolean("didUse", false);
                    EmberInventoryUtil.removeEmber((EntityPlayer)entity, 5.0);
                    if (EmberInventoryUtil.getEmberTotal((EntityPlayer)entity) < 5.0) {
                        stack.getTagCompound().setBoolean("poweredOn", false);
                    }
                }
            }
        }
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }

    @Override
    public boolean hasEmber(ItemStack stack) {
        if (stack.hasTagCompound()) {
            return stack.getTagCompound().getBoolean("poweredOn");
        }
        return false;
    }
}

