/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.Embers;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.item.IFilterItem;
import teamroots.embers.item.ItemBase;
import teamroots.embers.tileentity.ISpecialFilter;
import teamroots.embers.util.FilterUtil;

public class ItemGolemEye
extends ItemBase
implements IFilterItem {
    private static ThreadLocal<Float> eyeOpen = new ThreadLocal();

    public static void setEyeOpen(float amt) {
        eyeOpen.set(Float.valueOf(amt));
    }

    public ItemGolemEye(String name) {
        super(name, true);
        this.addPropertyOverride(new ResourceLocation("embers", "eye_open"), (stack, worldIn, entityIn) -> eyeOpen.get() != null ? eyeOpen.get().floatValue() : 0.0f);
    }

    public ActionResult<ItemStack> onItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.openGui((Object)Embers.instance, 1, worldIn, playerIn.getPosition().getX(), playerIn.getPosition().getY(), playerIn.getPosition().getZ());
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.getHeldItem(handIn));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof ISpecialFilter && player.isSneaking()) {
            ItemStack held = player.getHeldItem(hand);
            this.setFilter(held, ((ISpecialFilter)tile).getSpecialFilter());
            player.setHeldItem(hand, held);
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public void setFilter(ItemStack filterStack, IFilter filter) {
        NBTTagCompound compound = this.getOrCreateTagCompound(filterStack);
        compound.setTag("filter", (NBTBase)filter.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public IFilter getFilter(ItemStack filterStack) {
        NBTTagCompound compound = filterStack.getTagCompound();
        if (compound == null) {
            return FilterUtil.FILTER_ANY;
        }
        return FilterUtil.deserializeFilter(compound.getCompoundTag("filter"));
    }

    private NBTTagCompound getOrCreateTagCompound(ItemStack filterStack) {
        NBTTagCompound compound = filterStack.getTagCompound();
        if (compound == null) {
            compound = new NBTTagCompound();
            filterStack.setTagCompound(compound);
        }
        return compound;
    }

    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!stack.hasTagCompound()) {
            return;
        }
        IFilter filter = this.getFilter(stack);
        tooltip.add(filter.formatFilter());
    }

    public void reset(ItemStack filterStack) {
        NBTTagCompound compound = filterStack.getTagCompound();
        if (compound == null) {
            return;
        }
        compound.removeTag("comparator");
        compound.removeTag("offset");
    }
}

