/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.item.ItemBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberSparkleFX;
import teamroots.embers.register.BlockRegister;

public class ItemGlimmerShard
extends ItemBase {
    public ItemGlimmerShard() {
        super("glimmer_shard", true);
        this.setMaxStackSize(1);
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
            stack.getTagCompound().setInteger("light", 800);
        } else if (!world.isRemote && world.getLightBrightness(entity.getPosition()) > 0.625f && entity.posY > (double)(world.getTopSolidOrLiquidBlock(entity.getPosition()).getY() - 2)) {
            stack.getTagCompound().setInteger("light", Math.min(800, stack.getTagCompound().getInteger("light") + 1));
        }
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        BlockPos lightPos;
        ItemStack stack = player.getHeldItem(hand);
        if (stack.hasTagCompound() && stack.getTagCompound().getInteger("light") >= 10 && world.isAirBlock(lightPos = pos.offset(face))) {
            stack.getTagCompound().setInteger("light", stack.getTagCompound().getInteger("light") - 10);
            world.setBlockState(lightPos, BlockRegister.GLOW.getDefaultState());
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSparkleFX((double)lightPos.getX() + 0.5, (double)lightPos.getY() + 0.5, (double)lightPos.getZ() + 0.5, false));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.hasTagCompound() && stack.getTagCompound().getInteger("light") < 800;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Color.WHITE.getRGB();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.hasTagCompound()) {
            return (800.0 - (double)stack.getTagCompound().getInteger("light")) / 800.0;
        }
        return 0.0;
    }
}

