/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.client.model.ModelLoader;
import teamroots.embers.Embers;
import teamroots.embers.item.IModeledItem;

public class ItemAxeBase
extends ItemTool
implements IModeledItem {
    public ItemAxeBase(Item.ToolMaterial material, String name, boolean addToTab) {
        super(material, (Set)Sets.newHashSet((Object[])new Block[]{Blocks.PLANKS}));
        this.setTranslationKey(name);
        this.setRegistryName("embers:" + name);
        if (addToTab) {
            this.setCreativeTab(Embers.tab);
        }
        this.setHarvestLevel("axe", this.toolMaterial.getHarvestLevel());
        this.attackDamage = this.toolMaterial.getAttackDamage() + 6.0f;
        this.attackSpeed = -3.1f;
    }

    public float getDestroySpeed(ItemStack stack, IBlockState state) {
        Material material = state.getMaterial();
        return material != Material.WOOD && material != Material.PLANTS && material != Material.VINE ? super.getDestroySpeed(stack, state) : this.efficiency;
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }
}

