/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity.magmaworm;

import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.entity.magmaworm.Jump;

public class DownStuck
extends Jump {
    private boolean stuck;
    private double stuckTimer;
    private double velocityModifier = 0.1;

    public DownStuck(MagmaWormPhase.PhaseSupplier supplier) {
        super(supplier);
    }

    @Override
    protected Vec3d getTarget(EntityMagmaWorm worm) {
        double angle = this.random.nextDouble() * Math.PI * 2.0;
        double dx = Math.sin(angle) * 20.0;
        double dz = Math.cos(angle) * 20.0;
        double bottom = MagmaWormPhase.getHeight(worm.world, worm.posX + dx, worm.posZ + dz) - 10.0;
        return new Vec3d(worm.posX + dx, bottom, worm.posZ + dz);
    }

    @Override
    public double getVelocity(EntityMagmaWorm worm) {
        return this.velocityModifier;
    }

    @Override
    public void onUpdate(EntityMagmaWorm worm) {
        if (this.stuckTimer < 0.0) {
            this.velocityModifier = Math.min(1.0, this.velocityModifier + 0.01);
        }
        if (!this.stuck) {
            this.velocityModifier = Math.min(1.5, this.velocityModifier + 0.05);
        }
        this.stuckTimer -= 1.0;
    }

    @Override
    public void onDig(EntityMagmaWorm worm) {
        if (!this.stuck) {
            this.stuck = true;
            this.stuckTimer = 480.0;
            this.velocityModifier = 0.0;
        }
    }
}

