/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity.magmaworm;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.entity.magmaworm.Down;

public class DownAggressive
extends Down {
    private static final double RANGE_ATTACK = 36.0;
    private double velocity = 0.5;

    public DownAggressive(MagmaWormPhase.PhaseSupplier supplier) {
        super(supplier);
    }

    @Override
    public double getVelocity(EntityMagmaWorm worm) {
        if (worm.isDigging()) {
            return 0.5;
        }
        return this.velocity;
    }

    @Override
    public void onUpdate(EntityMagmaWorm worm) {
        this.velocity = Math.min(2.0, this.velocity + 0.05);
    }

    @Override
    protected Vec3d getTarget(EntityMagmaWorm worm) {
        List<Entity> targets = worm.getAttackTargets(new AxisAlignedBB(worm.posX - 36.0, worm.posY - 36.0, worm.posZ - 36.0, worm.posX + 36.0, worm.posY + 36.0, worm.posZ + 36.0));
        if (!targets.isEmpty()) {
            Entity target = targets.get(this.random.nextInt(targets.size()));
            double bottom = MagmaWormPhase.getHeight(target.world, target.posX, target.posZ) - 10.0;
            return new Vec3d(target.posX, bottom, target.posZ);
        }
        return super.getTarget(worm);
    }
}

