/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity.magmaworm;

import java.util.ArrayList;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.util.Bezier;

public class Burrow
extends MagmaWormPhase {
    private int digCooldown;
    private int undigCooldown;

    public Burrow(MagmaWormPhase.PhaseSupplier supplier) {
        super(supplier);
    }

    @Override
    public double getVelocity(EntityMagmaWorm worm) {
        return 1.0;
    }

    @Override
    public void onStart(EntityMagmaWorm worm) {
        int tries = this.random.nextInt(10) + 10;
        ArrayList<Vec3d> points = new ArrayList<Vec3d>();
        points.add(new Vec3d(worm.posX, worm.posY, worm.posZ));
        for (int i = 0; i < tries; ++i) {
            Vec3d lastPos = (Vec3d)points.get(points.size() - 1);
            double angle = this.random.nextDouble() * Math.PI * 2.0;
            double dx = Math.sin(angle) * 10.0;
            double dz = Math.cos(angle) * 10.0;
            double height = MagmaWormPhase.getHeight(worm.world, lastPos.x + dx, lastPos.z + dz);
            if (i % 2 == 0) {
                points.add(new Vec3d(lastPos.x + dx, height + 2.0, lastPos.z + dz));
                continue;
            }
            points.add(new Vec3d(lastPos.x + dx, height - 5.0, lastPos.z + dz));
        }
        worm.setCurrentSpline(new Bezier(points), 10, 0.3);
    }

    @Override
    public void onUpdate(EntityMagmaWorm worm) {
        --this.digCooldown;
        --this.undigCooldown;
    }

    @Override
    public void onDig(EntityMagmaWorm worm) {
        if (this.digCooldown > 0) {
            return;
        }
        Vec3d location = new Vec3d(worm.posX, worm.posY + 2.0, worm.posZ);
        Burrow.splashMagma(worm, location, 6);
        this.digCooldown = 30;
    }

    @Override
    public void onUndig(EntityMagmaWorm worm) {
        if (this.undigCooldown > 0) {
            return;
        }
        Vec3d location = new Vec3d(worm.posX, worm.posY + 2.0, worm.posZ);
        Burrow.splashMagma(worm, location, 6);
        this.undigCooldown = 30;
    }
}

