/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.DoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.ExtraSerializers;
import teamroots.embers.util.Misc;
import teamroots.embers.util.Spline;

public class EntityMagmaWorm
extends EntityFlying
implements IEntityMultiPart {
    public static final int RANGE_ATTACK = 72;
    public ArrayList<Vec3d> pastPositions = new ArrayList();
    public ArrayList<Vec3d> pastPositionsLast = new ArrayList();
    public MultiPartEntityPart[] wormPartArray;
    public static final DataParameter<Float> targetDirectionX = EntityDataManager.createKey(EntityMagmaWorm.class, (DataSerializer)DataSerializers.FLOAT);
    public static final DataParameter<Float> targetDirectionY = EntityDataManager.createKey(EntityMagmaWorm.class, (DataSerializer)DataSerializers.FLOAT);
    public static final DataParameter<Boolean> pacified = EntityDataManager.createKey(EntityMagmaWorm.class, (DataSerializer)DataSerializers.BOOLEAN);
    public static final DataParameter<Boolean> tracking = EntityDataManager.createKey(EntityMagmaWorm.class, (DataSerializer)DataSerializers.BOOLEAN);
    public static final DataParameter<Integer> fadeTimer = EntityDataManager.createKey(EntityMagmaWorm.class, (DataSerializer)DataSerializers.VARINT);
    public static final DataParameter<Integer> segments = EntityDataManager.createKey(EntityMagmaWorm.class, (DataSerializer)DataSerializers.VARINT);
    public static final DataParameter<float[]> segmentFade = EntityDataManager.createKey(EntityMagmaWorm.class, ExtraSerializers.FLOAT_ARRAY);
    public static final DataParameter<Boolean> digging = EntityDataManager.createKey(EntityMagmaWorm.class, (DataSerializer)DataSerializers.BOOLEAN);
    Random random = new Random();
    Spline currentSpline;
    double distMoved;
    double splineInterval;
    double pastPositionDistance;
    MagmaWormPhase currentPhase;
    public Vec3d moveVec = new Vec3d(0.0, 0.0, 0.0);
    public static SoundEvent ambientSound;
    public static SoundEvent hurtSound;
    public static SoundEvent departureSound;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.getDisplayName(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).setDarkenSky(true);

    public void setCurrentSpline(DoubleFunction<Vec3d> spline, int segments, double splineInterval) {
        this.moveVec = new Vec3d(this.motionX, this.motionY, this.motionZ);
        this.currentSpline = new Spline(spline);
        this.currentSpline.cachePoints(segments, 1.0, 1.0);
        this.splineInterval = this.currentSpline.getTotalArcLength() * splineInterval;
        this.distMoved = 0.0;
    }

    public void setCurrentSpline(Spline spline, double splineInterval) {
        this.moveVec = new Vec3d(this.motionX, this.motionY, this.motionZ);
        this.currentSpline = spline;
        this.splineInterval = splineInterval;
        this.distMoved = 0.0;
    }

    public void setSegmentFade(int index, float fade) {
        float[] value = (float[])this.getDataManager().get(segmentFade);
        if (value[index] == fade) {
            return;
        }
        value[index] = fade;
        this.getDataManager().set(segmentFade, (Object)value);
        this.getDataManager().setDirty(segmentFade);
    }

    public float getSegmentFade(int index) {
        float[] value = (float[])this.getDataManager().get(segmentFade);
        return value[index];
    }

    public void setSegments(int n) {
        this.getDataManager().set(segments, (Object)n);
        this.getDataManager().setDirty(segments);
    }

    public int getSegments() {
        return (Integer)this.getDataManager().get(segments);
    }

    public void setDigging(boolean flag) {
        this.getDataManager().set(digging, (Object)flag);
        this.getDataManager().setDirty(digging);
    }

    public boolean isDigging() {
        return (Boolean)this.getDataManager().get(digging);
    }

    @Nullable
    public Entity[] getParts() {
        return this.wormPartArray;
    }

    public EntityMagmaWorm(World worldIn) {
        super(worldIn);
        int i;
        this.setSize(2.0f, 2.0f);
        this.noClip = true;
        this.isAirBorne = true;
        this.experienceValue = 20;
        int segments = this.getSegments();
        for (i = 0; i < segments * 2; ++i) {
            this.pastPositions.add(new Vec3d(this.posX, this.posY, this.posZ));
            this.pastPositionsLast.add(new Vec3d(this.posX, this.posY, this.posZ));
        }
        this.wormPartArray = new MultiPartEntityPart[segments];
        for (i = 0; i < segments; ++i) {
            this.wormPartArray[i] = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 2.0f, 2.0f);
        }
        this.rotationYaw = this.rand.nextInt(240) + 60;
    }

    public boolean isNonBoss() {
        return false;
    }

    protected void entityInit() {
        super.entityInit();
        this.getDataManager().register(pacified, (Object)false);
        this.getDataManager().register(tracking, (Object)false);
        this.getDataManager().register(targetDirectionX, (Object)Float.valueOf(0.0f));
        this.getDataManager().register(targetDirectionY, (Object)Float.valueOf(0.0f));
        this.getDataManager().register(fadeTimer, (Object)0);
        this.getDataManager().register(segments, (Object)15);
        this.getDataManager().register(segmentFade, (Object)new float[15]);
        this.getDataManager().register(digging, (Object)false);
    }

    public void collideWithEntity(Entity entity) {
        if (this.getAttackTarget() != null && this.getHealth() > 0.0f && !((Boolean)this.getDataManager().get(pacified)).booleanValue() && entity.getUniqueID().compareTo(this.getAttackTarget().getUniqueID()) == 0 && entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (Misc.isCreativePlayer(living)) {
                return;
            }
            living.attackEntityFrom(DamageSource.GENERIC, 4.0f);
            float magnitude = (float)Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            living.knockBack((Entity)this, 3.0f * magnitude + 0.1f, -this.motionX / (double)magnitude + 0.1, -this.motionZ / (double)magnitude + 0.1);
            living.attackEntityAsMob((Entity)this);
            living.setRevengeTarget((EntityLivingBase)this);
        }
    }

    public void updateAITasks() {
        super.updateAITasks();
    }

    public Vec3d getSegmentPosition(int index, float partialTicks) {
        Vec3d pos1 = this.pastPositionsLast.get(index);
        Vec3d pos2 = this.pastPositions.get(index);
        return new Vec3d(MathHelper.clampedLerp((double)pos1.x, (double)pos2.x, (double)partialTicks), MathHelper.clampedLerp((double)pos1.y, (double)pos2.y, (double)partialTicks), MathHelper.clampedLerp((double)pos1.z, (double)pos2.z, (double)partialTicks));
    }

    public Vec3d getHeadPosition(float partialTicks) {
        return new Vec3d(MathHelper.clampedLerp((double)this.prevPosX, (double)this.posX, (double)partialTicks), MathHelper.clampedLerp((double)this.prevPosY, (double)this.posY, (double)partialTicks), MathHelper.clampedLerp((double)this.prevPosZ, (double)this.posZ, (double)partialTicks));
    }

    public void setPhase(MagmaWormPhase phase, boolean interrupt) {
        if (this.currentPhase != null) {
            if (interrupt) {
                this.currentPhase.onInterrupt(this);
            } else {
                this.currentPhase.onEnd(this);
            }
        }
        this.currentPhase = phase;
        this.currentPhase.onStart(this);
    }

    public List<Entity> getAttackTargets(AxisAlignedBB aabb) {
        return this.world.getEntitiesWithinAABB(EntityPlayer.class, aabb);
    }

    public void onUpdate() {
        int i;
        if (!this.world.isRemote) {
            if (this.currentPhase == null) {
                this.setPhase(MagmaWormPhase.START.get(), false);
            } else if (this.distMoved >= this.currentSpline.getTotalArcLength()) {
                MagmaWormPhase phase = this.currentPhase.pickFollowup(this.random);
                this.setPhase(phase, false);
            }
        }
        super.onUpdate();
        for (int i2 = 0; i2 < this.pastPositions.size(); ++i2) {
            this.pastPositionsLast.set(i2, this.pastPositions.get(i2));
        }
        if (this.world.getDifficulty() == EnumDifficulty.PEACEFUL) {
            this.setDead();
            return;
        }
        float velocityScale = 0.7f;
        float addedMotionY = 0.0f;
        if (((Boolean)this.getDataManager().get(pacified)).booleanValue() && (Integer)this.getDataManager().get(fadeTimer) > 0) {
            this.getDataManager().set(fadeTimer, (Object)((Integer)this.getDataManager().get(fadeTimer) - 1));
            this.getDataManager().setDirty(fadeTimer);
        }
        if ((Integer)this.getDataManager().get(fadeTimer) > 0) {
            for (i = 0; i < 5; ++i) {
                Vec3d location = this.pastPositions.get(this.rand.nextInt(20)).add(new Vec3d((double)this.rand.nextFloat() - 0.5, (double)this.rand.nextFloat() - 0.5, (double)this.rand.nextFloat() - 0.5).scale(3.0));
                ParticleUtil.spawnParticleGlowThroughBlocks(this.getEntityWorld(), (float)location.x, (float)location.y + 1.35f, (float)location.z, 0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 0.06f, 1.0f, 5.0f, 20);
            }
        }
        if ((Integer)this.getDataManager().get(fadeTimer) == 0 && ((Boolean)this.getDataManager().get(pacified)).booleanValue()) {
            for (i = 0; i < this.getSegments(); ++i) {
                Vec3d location;
                int j;
                for (j = 0; j < 5; ++j) {
                    location = this.pastPositions.get(i).add(new Vec3d((double)this.rand.nextFloat() - 0.5, (double)this.rand.nextFloat() - 0.5, (double)this.rand.nextFloat() - 0.5).scale(3.0));
                    ParticleUtil.spawnParticleGlowThroughBlocks(this.getEntityWorld(), (float)location.x, (float)location.y + 1.35f, (float)location.z, 0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 0.06f, 1.0f, 5.0f, 20);
                }
                for (j = 0; j < 2; ++j) {
                    location = this.pastPositions.get(i).add(new Vec3d((double)this.rand.nextFloat() - 0.5, (double)this.rand.nextFloat() - 0.5, (double)this.rand.nextFloat() - 0.5).scale(1.5));
                    ParticleUtil.spawnParticleGlowThroughBlocks(this.getEntityWorld(), (float)location.x, (float)location.y + 1.35f, (float)location.z, 0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 0.06f, 1.0f, 5.0f, 20);
                }
            }
            this.setDead();
        }
        if (this.world.isRemote) {
            for (i = 0; i < Math.max(this.getSegments() - 2, 0); ++i) {
                Vec3d location;
                Vec3d velocity;
                int j;
                for (j = 0; j < 5; ++j) {
                    velocity = Vec3d.fromPitchYaw((float)(this.rand.nextFloat() * 360.0f), (float)(this.rand.nextFloat() * 360.0f)).scale((double)0.2f);
                    location = this.pastPositions.get(i).add(new Vec3d((double)this.rand.nextFloat() - 0.5, (double)this.rand.nextFloat() - 0.5, (double)this.rand.nextFloat() - 0.5).scale(3.0).scale(0.0));
                    ParticleUtil.spawnParticleGlow(this.getEntityWorld(), (float)location.x, (float)location.y + 1.35f, (float)location.z, (float)velocity.x, (float)velocity.y, (float)velocity.z, 1.0f, 0.25f, 0.06f, 1.0f, 3.0f, 20);
                }
                for (j = 0; j < 2; ++j) {
                    velocity = Vec3d.fromPitchYaw((float)(this.rand.nextFloat() * 360.0f), (float)(this.rand.nextFloat() * 360.0f)).scale((double)0.2f);
                    location = this.pastPositions.get(i).add(new Vec3d((double)this.rand.nextFloat() - 0.5, (double)this.rand.nextFloat() - 0.5, (double)this.rand.nextFloat() - 0.5).scale(1.5).scale(0.0));
                    ParticleUtil.spawnParticleGlow(this.getEntityWorld(), (float)location.x, (float)location.y + 1.35f, (float)location.z, 0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 0.06f, 1.0f, 5.0f, 20);
                }
            }
        }
        if (this.currentPhase != null && !this.world.isRemote) {
            this.currentPhase.onUpdate(this);
        }
        if (this.ticksExisted % 20 == 20) {
            List<EntityPlayer> playersValid = Misc.getNonCreativePlayers(this.world, new AxisAlignedBB(this.posX - 72.0, this.posY - 72.0, this.posZ - 72.0, this.posX + 72.0, this.posY + 72.0, this.posZ + 72.0));
            boolean foundPrevious = false;
            if (this.getAttackTarget() != null) {
                for (int i3 = 0; i3 < playersValid.size(); ++i3) {
                    if (playersValid.get(i3).getUniqueID().compareTo(this.getAttackTarget().getUniqueID()) != 0) continue;
                    foundPrevious = true;
                }
            }
            if (!foundPrevious && playersValid.size() > 0) {
                this.setAttackTarget((EntityLivingBase)playersValid.get(this.rand.nextInt(playersValid.size())));
            }
            if (this.random.nextInt(6) == 0) {
                // empty if block
            }
        }
        if (this.getAttackTarget() != null) {
            float distanceToTarget = (float)Math.sqrt(Math.pow(this.posX - this.getAttackTarget().posX, 2.0) + Math.pow(this.posZ - this.getAttackTarget().posZ, 2.0));
            if (distanceToTarget > 30.0f && !((Boolean)this.getDataManager().get(tracking)).booleanValue()) {
                this.getDataManager().set(tracking, (Object)true);
                this.getDataManager().setDirty(tracking);
            }
            velocityScale = (Boolean)this.getDataManager().get(pacified) == false ? 1.0f + Math.max(-0.875f, (25.0f - distanceToTarget) / 20.0f) : Math.max(0.0f, 20.0f - Math.min(20.0f, 200.0f - (float)((Integer)this.getDataManager().get(fadeTimer)).intValue())) / 200.0f;
        }
        if (this.getAttackTarget() != null && ((Boolean)this.getDataManager().get(tracking)).booleanValue() && !this.getEntityWorld().isRemote) {
            this.getDataManager().set(targetDirectionX, (Object)Float.valueOf((float)Math.toRadians(Misc.yawDegreesBetweenPointsSafe(this.posX, this.posY, this.posZ, this.getAttackTarget().posX, this.getAttackTarget().posY + (double)this.getAttackTarget().getEyeHeight() / 2.0, this.getAttackTarget().posZ, ((Float)this.getDataManager().get(targetDirectionX)).floatValue()))));
            this.getDataManager().set(targetDirectionY, (Object)Float.valueOf((float)Math.toRadians(Misc.pitchDegreesBetweenPoints(this.posX, this.posY, this.posZ, this.getAttackTarget().posX, this.getAttackTarget().posY + (double)this.getAttackTarget().getEyeHeight() / 2.0, this.getAttackTarget().posZ))));
            this.getDataManager().setDirty(targetDirectionX);
            this.getDataManager().setDirty(targetDirectionY);
        }
        if (this.getAttackTarget() == null && this.ticksExisted % 25 == 0 && !this.getEntityWorld().isRemote) {
            this.getDataManager().set(targetDirectionX, (Object)Float.valueOf((float)Math.toRadians(this.random.nextFloat() * 360.0f)));
            this.getDataManager().set(targetDirectionY, (Object)Float.valueOf((float)Math.toRadians(this.random.nextFloat() * 180.0f - 90.0f)));
            this.getDataManager().setDirty(targetDirectionX);
            this.getDataManager().setDirty(targetDirectionY);
        }
        this.noClip = false;
        boolean insideBlock = this.isEntityInsideOpaqueBlock();
        if (this.currentPhase != null) {
            if (insideBlock && !this.isDigging()) {
                this.currentPhase.onDig(this);
            }
            if (!insideBlock && this.isDigging()) {
                this.currentPhase.onUndig(this);
            }
        }
        this.setDigging(insideBlock);
        this.noClip = true;
        if (this.currentPhase != null) {
            velocityScale = (float)this.currentPhase.getVelocity(this);
        }
        if ((Integer)this.getDataManager().get(fadeTimer) <= 180 && (Integer)this.getDataManager().get(fadeTimer) != 0) {
            velocityScale = 0.0f;
        }
        int interval = 25;
        if (this.ticksExisted % 200 >= 180) {
            interval = 5;
        }
        for (int i4 = 0; i4 < this.getSegments(); ++i4) {
            this.setSegmentFade(i4, 1.0f);
        }
        if (this.currentSpline != null) {
            this.distMoved += (double)velocityScale;
            Vec3d nextPoint = this.currentSpline.getPoint(this.distMoved);
            if (this.distMoved < this.splineInterval) {
                double intervalLerp = this.distMoved / this.splineInterval;
                nextPoint = new Vec3d(MathHelper.clampedLerp((double)(this.posX + this.moveVec.x), (double)nextPoint.x, (double)intervalLerp), MathHelper.clampedLerp((double)(this.posY + this.moveVec.y), (double)nextPoint.y, (double)intervalLerp), MathHelper.clampedLerp((double)(this.posZ + this.moveVec.z), (double)nextPoint.z, (double)intervalLerp));
            } else if (this.distMoved > this.currentSpline.getTotalArcLength()) {
                this.moveVec = new Vec3d(this.motionX, this.motionY, this.motionZ);
            }
            this.motionX = nextPoint.x - this.posX;
            this.motionY = nextPoint.y - this.posY;
            this.motionZ = nextPoint.z - this.posZ;
        }
        this.rotationYaw = (float)Math.toRadians(Misc.yawDegreesBetweenPointsSafe(0.0, 0.0, 0.0, this.motionX, this.motionY, this.motionZ, this.rotationYaw));
        this.rotationPitch = (float)Math.toRadians(Misc.pitchDegreesBetweenPoints(0.0, 0.0, 0.0, this.motionX, this.motionY, this.motionZ));
        if ((Integer)this.getDataManager().get(fadeTimer) > 180 || (Integer)this.getDataManager().get(fadeTimer) == 0) {
            if (this.pastPositions.get((int)0).x == 0.0 && this.pastPositions.get((int)0).y == 0.0 && this.pastPositions.get((int)0).z == 0.0) {
                this.pastPositions.set(0, new Vec3d(this.posX, this.posY, this.posZ));
            }
            for (int i5 = 1; i5 < this.pastPositions.size(); ++i5) {
                if (this.pastPositions.get((int)i5).x != 0.0 || this.pastPositions.get((int)i5).y != 0.0 || this.pastPositions.get((int)i5).z != 0.0) continue;
                this.pastPositions.set(i5, this.pastPositions.get(i5 - 1));
            }
            if (this.world.isRemote) {
                System.out.println();
            }
            double dx = this.posX - this.prevPosX;
            double dy = this.posY - this.prevPosY;
            double dz = this.posZ - this.prevPosZ;
            this.pastPositionDistance += Math.sqrt(dx * dx + dy * dy + dz * dz);
            int g = 0;
            while ((double)g < this.pastPositionDistance / 0.5) {
                for (int i6 = this.pastPositions.size() - 1; i6 > 0; --i6) {
                    this.pastPositions.set(i6, this.pastPositions.get(i6).scale(0.5).add(this.pastPositions.get(i6 - 1).scale(0.5)));
                }
                this.pastPositions.set(0, new Vec3d(this.posX, this.posY, this.posZ));
                this.pastPositionDistance -= 0.5;
                ++g;
            }
        }
        for (int i7 = 0; i7 < this.wormPartArray.length; ++i7) {
            Vec3d position = this.pastPositions.get(i7);
            Vec3d positionLast = this.pastPositionsLast.get(i7);
            MultiPartEntityPart part = this.wormPartArray[i7];
            part.onUpdate();
            part.setLocationAndAngles(position.x, position.y, position.z, 0.0f, 0.0f);
            part.prevPosX = positionLast.x;
            part.prevPosY = positionLast.y;
            part.prevPosZ = positionLast.z;
        }
    }

    public boolean isEntityInvulnerable(DamageSource source) {
        return (Boolean)this.getDataManager().get(pacified) != false;
    }

    public int getBrightnessForRender() {
        float f = 0.5f;
        f = MathHelper.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getBrightnessForRender();
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (source.getTrueSource() instanceof EntityLivingBase) {
            this.setAttackTarget((EntityLivingBase)source.getTrueSource());
            EntityLivingBase entityLivingBase = (EntityLivingBase)source.getTrueSource();
        }
        return super.attackEntityFrom(source, amount);
    }

    public void damageEntity(DamageSource source, float amount) {
        if (this.getHealth() - amount <= 0.0f && !((Boolean)this.getDataManager().get(pacified)).booleanValue()) {
            this.setHealth(1.0f);
            this.bossInfo.setPercent(0.0f);
            this.getDataManager().set(pacified, (Object)true);
            this.getDataManager().setDirty(pacified);
            this.getDataManager().set(fadeTimer, (Object)200);
            if (source.getTrueSource() instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)source.getTrueSource();
            }
        } else if (!((Boolean)this.getDataManager().get(pacified)).booleanValue()) {
            super.damageEntity(source, amount);
            this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
        }
    }

    public boolean attackEntityAsMob(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.setAttackTarget((EntityLivingBase)entity);
        }
        return super.attackEntityAsMob(entity);
    }

    public boolean isAIDisabled() {
        return false;
    }

    public void setDead() {
        if (!this.isDead && !this.world.isRemote) {
            this.entityDropItem(new ItemStack(Items.TOTEM_OF_UNDYING), 4.0f);
        }
        super.setDead();
    }

    protected boolean canDespawn() {
        return false;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(320.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(2.0);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(6.0);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.getDataManager().set(targetDirectionX, (Object)Float.valueOf(compound.getFloat("targetDirectionX")));
        this.getDataManager().set(targetDirectionY, (Object)Float.valueOf(compound.getFloat("targetDirectionY")));
        this.getDataManager().set(fadeTimer, (Object)compound.getInteger("fadeTimer"));
        this.getDataManager().set(pacified, (Object)compound.getBoolean("pacified"));
        this.getDataManager().set(tracking, (Object)compound.getBoolean("tracking"));
        this.getDataManager().setDirty(targetDirectionX);
        this.getDataManager().setDirty(targetDirectionY);
        this.getDataManager().setDirty(pacified);
        this.getDataManager().setDirty(tracking);
        this.getDataManager().setDirty(fadeTimer);
        this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setFloat("targetDirectionX", ((Float)this.getDataManager().get(targetDirectionX)).floatValue());
        compound.setFloat("targetDirectionY", ((Float)this.getDataManager().get(targetDirectionY)).floatValue());
        compound.setBoolean("pacified", ((Boolean)this.getDataManager().get(pacified)).booleanValue());
        compound.setBoolean("tracking", ((Boolean)this.getDataManager().get(tracking)).booleanValue());
        compound.setInteger("fadeTimer", ((Integer)this.getDataManager().get(fadeTimer)).intValue());
    }

    public float getFade(float partialTicks) {
        if ((Integer)this.getDataManager().get(fadeTimer) == 0) {
            return 1.0f;
        }
        return Math.max(0.0f, ((float)((Integer)this.getDataManager().get(fadeTimer)).intValue() - partialTicks) / 200.0f);
    }

    public void addTrackingPlayer(EntityPlayerMP player) {
        super.addTrackingPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void removeTrackingPlayer(EntityPlayerMP player) {
        super.removeTrackingPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    @Nullable
    protected ResourceLocation getLootTable() {
        return new ResourceLocation("embers", "entity/magma_worm");
    }

    public World getWorld() {
        return this.world;
    }

    public int getIndex(MultiPartEntityPart part) {
        Entity[] parts = this.getParts();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] != part) continue;
            return i;
        }
        return -1;
    }

    public boolean attackEntityFromPart(MultiPartEntityPart part, DamageSource source, float damage) {
        int index = this.getIndex(part);
        return false;
    }
}

