/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberBurstFX;
import teamroots.embers.network.message.MessageFireBlastFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.Misc;

public class EntityMagmaProjectile
extends Entity {
    private final Predicate<Entity> VALID_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.NOT_SPECTATING, EntitySelectors.IS_ALIVE, new Predicate<Entity>(){

        public boolean apply(Entity entity) {
            return entity.canBeCollidedWith() && entity != EntityMagmaProjectile.this.owner;
        }
    }});
    public static final DataParameter<Integer> typeOrdinal = EntityDataManager.createKey(EntityMagmaProjectile.class, (DataSerializer)DataSerializers.VARINT);
    public static final DataParameter<Float> explosionTimer = EntityDataManager.createKey(EntityMagmaProjectile.class, (DataSerializer)DataSerializers.FLOAT);
    public static final DataParameter<Float> pillarHeight = EntityDataManager.createKey(EntityMagmaProjectile.class, (DataSerializer)DataSerializers.FLOAT);
    public static final DataParameter<Integer> tick = EntityDataManager.createKey(EntityMagmaProjectile.class, (DataSerializer)DataSerializers.VARINT);
    EntityMagmaWorm owner;
    Supplier<Vec3d> homingTarget;
    double homingRatio = 0.1;
    double homingVelocity = 0.3;
    Predicate<Entity> entityTarget = this.VALID_TARGETS;
    boolean pierceBlocks = false;
    double gravity;
    double maxGravity;

    public EntityMagmaProjectile(World worldIn) {
        super(worldIn);
    }

    public EntityMagmaProjectile(World worldIn, EntityMagmaWorm owner) {
        super(worldIn);
        this.owner = owner;
    }

    public void makeMortar(Vec3d velocity) {
        this.setType(Type.MORTAR);
        this.motionX = velocity.x;
        this.motionY = velocity.y;
        this.motionZ = velocity.z;
        this.gravity = 0.007;
        this.maxGravity = this.rand.nextDouble() * 0.2 + 0.1;
        this.setExplosionTimer(1.0f);
        this.entityTarget = Predicates.alwaysFalse();
    }

    public void makePillar(float height, int delay) {
        this.setType(Type.PILLAR);
        this.setExplosionTimer(1.0f);
        this.entityTarget = Predicates.alwaysFalse();
        this.pierceBlocks = true;
        this.setPillarHeight(height);
        this.setTick(-delay);
    }

    public void makeHoming(Vec3d velocity, Entity target) {
        this.setType(Type.HOMING);
        this.motionX = velocity.x;
        this.motionY = velocity.y;
        this.motionZ = velocity.z;
        this.homingRatio = 0.0;
        this.homingVelocity = 0.6;
        this.homingTarget = () -> new Vec3d(target.posX, target.posY + (double)(target.height / 2.0f), target.posZ);
    }

    public void makeSplash(Vec3d velocity) {
        this.setType(Type.SPLASH);
        this.motionX = velocity.x;
        this.motionY = velocity.y;
        this.motionZ = velocity.z;
        this.gravity = 0.007;
        this.maxGravity = 0.5;
        this.pierceBlocks = true;
    }

    public void onUpdate() {
        super.onUpdate();
        int tick = this.getTick();
        float explosionTimer = this.getExplosionTimer();
        switch (this.getType()) {
            case GUN: {
                break;
            }
            case MORTAR: {
                if (!this.world.isRemote) {
                    double height = this.world.getHeight(this.getPosition()).getY();
                    if (this.posY < height + 1.5) {
                        this.motionY = Math.max(this.motionY, 0.0) + 0.04;
                    }
                    if (tick > 100) {
                        this.motionX *= 0.9;
                        this.motionZ *= 0.9;
                    }
                    if (this.posY < height + 3.0 && this.motionY > 0.0 || explosionTimer < 1.0f) {
                        this.setExplosionTimer(explosionTimer - 0.05f);
                    }
                    if (!(explosionTimer <= 0.0f)) break;
                    this.setDead();
                    PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageFireBlastFX(this.posX, this.posY - 1.0, this.posZ, new Color(255, 64, 16), 5.0f, 15), (Entity)this);
                    break;
                }
                if (!(explosionTimer > 0.0f) || !(explosionTimer < 1.0f)) break;
                this.showTimer(explosionTimer, 12, 30, new Color(255, 64, 16), 3.0, 1.0f);
                break;
            }
            case PILLAR: {
                float chargeTimer = 1.0f - (float)tick / 40.0f;
                float pillarTimer = ((float)tick - 40.0f) / 40.0f;
                if (!this.world.isRemote) {
                    if (!(pillarTimer > 1.0f)) break;
                    this.setDead();
                    break;
                }
                if (chargeTimer > 0.0f && chargeTimer < 1.0f) {
                    this.showTimer(chargeTimer, 50, 10, new Color(255, 64, 16), 3.0, 0.0f);
                    break;
                }
                if (!(pillarTimer > 0.0f) || !(pillarTimer < 1.0f)) break;
                double height = Math.sin((double)MathHelper.clamp((float)pillarTimer, (float)0.0f, (float)1.0f) * Math.PI) * (double)this.getPillarHeight();
                Color particleColor = new Color(255, 64, 16);
                int i = 0;
                while ((double)i < height) {
                    for (int e = 0; e < 5; ++e) {
                        double width = Math.cos((double)MathHelper.clamp((float)pillarTimer, (float)0.0f, (float)1.0f) * Math.PI * 0.5) * 6.0;
                        int lifetime = this.rand.nextInt(20) + 20;
                        double angle = this.rand.nextDouble() * Math.PI * 2.0;
                        double dx = Math.sin(angle) * width / (double)lifetime;
                        double dy = (0.5 + this.rand.nextDouble() * 1.0) / (double)lifetime;
                        double dz = Math.cos(angle) * width / (double)lifetime;
                        ParticleUtil.spawnParticleGlow(this.world, (float)this.posX, (float)(this.posY + this.rand.nextDouble() * height), (float)this.posZ, (float)dx, (float)dy, (float)dz, particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), (float)(width * 3.0), lifetime);
                    }
                    ++i;
                }
                break;
            }
            case HOMING: {
                if (tick > 250) {
                    this.setDead();
                    break;
                }
                if (tick > 150 || this.homingTarget != null && this.getPositionVector().squareDistanceTo((Vec3d)this.homingTarget.get()) < 25.0) {
                    this.homingTarget = null;
                    break;
                }
                if (tick <= 20) break;
                this.homingRatio += 0.001;
                break;
            }
            case SPLASH: {
                this.motionX *= 0.98;
                this.motionZ *= 0.98;
                if (tick <= 100) break;
                this.setDead();
                break;
            }
            case TURRET: {
                break;
            }
            case TURRET_FLOAT: {
                break;
            }
        }
        this.updateMove();
        this.setTick(tick + 1);
    }

    public void showTimer(float timer, int segments, int lifetime, Color color, double size, float variance) {
        Random random = new Random(this.getEntityId());
        int tick = this.getTick();
        float segmentSize = 360.0f / (float)segments;
        float angleOffset = tick * 5;
        float pitchVariance = 20.0f * variance;
        for (int i = 0; i < segments; ++i) {
            float yaw = (float)i / (float)segments * 360.0f + angleOffset;
            Vec3d offset = Vec3d.fromPitchYaw((float)(random.nextFloat() * pitchVariance - pitchVariance / 2.0f), (float)(yaw + random.nextFloat() * segmentSize * variance * 0.5f)).scale(size * (double)timer);
            ParticleUtil.spawnParticleGlow(this.world, (float)(this.posX + offset.x), (float)(this.posY + offset.y), (float)(this.posZ + offset.z), 0.0f, 0.0f, 0.0f, color.getRed(), color.getGreen(), color.getBlue(), 3.0f, lifetime);
        }
    }

    public void updateMove() {
        RayTraceResult hitEntity;
        Vec3d newPosVector;
        Vec3d currPosVec = new Vec3d(this.posX, this.posY, this.posZ);
        Vec3d hitVec = newPosVector = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        RayTraceResult raytraceresult = this.world.rayTraceBlocks(currPosVec, newPosVector, false, true, false);
        if (raytraceresult != null && raytraceresult.typeOfHit != RayTraceResult.Type.MISS && !this.canPierce(raytraceresult)) {
            hitVec = raytraceresult.hitVec;
        }
        if ((hitEntity = Misc.findEntityOnPath(this.world, this, (Entity)this.owner, this.getEntityBoundingBox(), currPosVec, hitVec, this.entityTarget)) != null) {
            if (!this.canPierce(hitEntity)) {
                hitVec = hitEntity.hitVec;
            }
            raytraceresult = hitEntity;
        }
        if (-this.motionY < this.maxGravity) {
            this.motionY -= this.gravity;
        }
        if (!this.world.isRemote && raytraceresult != null && raytraceresult.typeOfHit != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onHit(raytraceresult);
        }
        newPosVector = hitVec;
        this.posX = newPosVector.x;
        this.posY = newPosVector.y;
        this.posZ = newPosVector.z;
        this.handleHoming();
        this.handleTrail();
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public void handleTrail() {
        if (this.world.isRemote) {
            Color particleColor = new Color(255, 64, 16);
            double deltaX = this.posX - this.prevPosX;
            double deltaY = this.posY - this.prevPosY;
            double deltaZ = this.posZ - this.prevPosZ;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 10.0);
            block8: for (double i = 0.0; i < dist; i += 1.0) {
                double coeff = i / dist;
                float px = (float)(this.prevPosX + (this.posX - this.prevPosX) * coeff);
                float py = (float)(this.prevPosY + (this.posY - this.prevPosY) * coeff);
                float pz = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * coeff);
                switch (this.getType()) {
                    case GUN: {
                        continue block8;
                    }
                    case MORTAR: {
                        float explosionTimer = this.getExplosionTimer();
                        double height = this.world.getHeight(this.getPosition()).getY();
                        if (this.posY < height + 4.0 || explosionTimer < 1.0f) {
                            ParticleUtil.spawnParticleGlow(this.world, px, py, pz, 0.025f * (this.rand.nextFloat() - 0.5f), 0.025f * this.rand.nextFloat(), 0.025f * (this.rand.nextFloat() - 0.5f), particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), 6.0f, 20);
                            continue block8;
                        }
                        ParticleUtil.spawnParticleGlow(this.world, px, py, pz, 0.0125f * (this.rand.nextFloat() - 0.5f), 0.1f * this.rand.nextFloat(), 0.0125f * (this.rand.nextFloat() - 0.5f), particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), 2.0f, 12);
                        continue block8;
                    }
                    case PILLAR: {
                        continue block8;
                    }
                    case HOMING: {
                        ParticleUtil.spawnParticleGlow(this.world, px, py, pz, 0.0125f * (this.rand.nextFloat() - 0.5f), 0.0125f * (this.rand.nextFloat() - 0.5f), 0.0125f * (this.rand.nextFloat() - 0.5f), particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), 4.0f, 12);
                        continue block8;
                    }
                    case SPLASH: {
                        ParticleUtil.spawnParticleGlow(this.world, px, py, pz, 0.025f * (this.rand.nextFloat() - 0.5f), -0.025f * this.rand.nextFloat(), 0.025f * (this.rand.nextFloat() - 0.5f), particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), 6.0f, 40);
                        continue block8;
                    }
                    case TURRET: {
                        continue block8;
                    }
                }
            }
        }
    }

    private void handleHoming() {
        if (this.homingTarget != null) {
            Vec3d homingPosition = (Vec3d)this.homingTarget.get();
            double targetX = homingPosition.x;
            double targetY = homingPosition.y;
            double targetZ = homingPosition.z;
            Vec3d targetVector = new Vec3d(targetX - this.posX, targetY - this.posY, targetZ - this.posZ);
            double length = targetVector.length();
            targetVector = targetVector.scale(this.homingVelocity / length);
            this.motionX = (1.0 - this.homingRatio) * this.motionX + this.homingRatio * targetVector.x;
            this.motionY = (1.0 - this.homingRatio) * this.motionY + this.homingRatio * targetVector.y;
            this.motionZ = (1.0 - this.homingRatio) * this.motionZ + this.homingRatio * targetVector.z;
        }
    }

    private boolean canPierce(@Nonnull RayTraceResult rayTraceResult) {
        if (rayTraceResult.typeOfHit == RayTraceResult.Type.BLOCK) {
            return this.pierceBlocks;
        }
        return true;
    }

    private void onHit(RayTraceResult rayTraceResult) {
        if (this.getType() == Type.SPLASH) {
            return;
        }
        Vec3d hitPos = rayTraceResult.hitVec;
        PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageEmberBurstFX(hitPos.x, hitPos.y, hitPos.z), (Entity)this);
        this.setDead();
    }

    public float getExplosionTimer() {
        return ((Float)this.getDataManager().get(explosionTimer)).floatValue();
    }

    public void setExplosionTimer(float time) {
        this.getDataManager().set(explosionTimer, (Object)Float.valueOf(time));
        this.getDataManager().setDirty(explosionTimer);
    }

    public float getPillarHeight() {
        return ((Float)this.getDataManager().get(pillarHeight)).floatValue();
    }

    public void setPillarHeight(float height) {
        this.getDataManager().set(pillarHeight, (Object)Float.valueOf(height));
        this.getDataManager().setDirty(pillarHeight);
    }

    public int getTick() {
        return (Integer)this.getDataManager().get(tick);
    }

    public void setTick(int n) {
        this.getDataManager().set(tick, (Object)n);
        this.getDataManager().setDirty(tick);
    }

    public Type getType() {
        Type[] values = Type.values();
        Integer ordinal = (Integer)this.getDataManager().get(typeOrdinal);
        return values[MathHelper.clamp((int)ordinal, (int)0, (int)(values.length - 1))];
    }

    public void setType(Type type) {
        this.getDataManager().set(typeOrdinal, (Object)type.ordinal());
        this.getDataManager().setDirty(typeOrdinal);
    }

    protected void entityInit() {
        this.getDataManager().register(typeOrdinal, (Object)Type.GUN.ordinal());
        this.getDataManager().register(explosionTimer, (Object)Float.valueOf(0.0f));
        this.getDataManager().register(pillarHeight, (Object)Float.valueOf(0.0f));
        this.getDataManager().register(tick, (Object)0);
    }

    protected void readEntityFromNBT(NBTTagCompound compound) {
    }

    protected void writeEntityToNBT(NBTTagCompound compound) {
    }

    static enum Type {
        GUN,
        MORTAR,
        PILLAR,
        HOMING,
        SPLASH,
        TURRET_FLOAT,
        TURRET,
        TURRET_HEAL;

    }
}

