/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.api.projectile.IProjectileEffect;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberSizedBurstFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.Misc;

public class EntityEmberProjectile
extends Entity {
    private static final Predicate<Entity> VALID_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.NOT_SPECTATING, EntitySelectors.IS_ALIVE, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity.canBeCollidedWith();
        }
    }});
    public static final DataParameter<Float> value = EntityDataManager.createKey(EntityEmberProjectile.class, (DataSerializer)DataSerializers.FLOAT);
    public static final DataParameter<Boolean> dead = EntityDataManager.createKey(EntityEmberProjectile.class, (DataSerializer)DataSerializers.BOOLEAN);
    public static final DataParameter<Integer> lifetime = EntityDataManager.createKey(EntityEmberProjectile.class, (DataSerializer)DataSerializers.VARINT);
    public static final DataParameter<Integer> color = EntityDataManager.createKey(EntityEmberProjectile.class, (DataSerializer)DataSerializers.VARINT);
    public Entity shootingEntity;
    public IProjectileEffect effect;
    private IProjectilePreset preset;
    double gravity;
    int homingTime;
    double homingRange;
    int homingIndex;
    int homingModulo;
    Entity homingTarget;
    Predicate<Entity> homingPredicate;

    public EntityEmberProjectile(World worldIn) {
        super(worldIn);
        this.setInvisible(true);
        this.getDataManager().register(value, (Object)Float.valueOf(0.0f));
        this.getDataManager().register(dead, (Object)false);
        this.getDataManager().register(lifetime, (Object)160);
        this.getDataManager().register(color, (Object)new Color(255, 64, 16).getRGB());
    }

    public void initCustom(double x, double y, double z, double vx, double vy, double vz, double value, Entity shootingEntity) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.motionX = vx;
        this.motionY = vy;
        this.motionZ = vz;
        this.setSize((float)value / 10.0f, (float)value / 10.0f);
        this.getDataManager().set(EntityEmberProjectile.value, (Object)Float.valueOf((float)value));
        this.getDataManager().setDirty(EntityEmberProjectile.value);
        this.setSize((float)value / 10.0f, (float)value / 10.0f);
        this.shootingEntity = shootingEntity;
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    public void setColor(int red, int green, int blue, int alpha) {
        this.getDataManager().set(color, (Object)new Color(red * alpha / 255, green * alpha / 255, blue * alpha / 255).getRGB());
        this.getDataManager().setDirty(color);
    }

    public void setHoming(int time, double range, int index, int modulo, Predicate<Entity> predicate) {
        this.homingTime = time;
        this.homingRange = range;
        this.homingIndex = index;
        this.homingModulo = modulo;
        this.homingPredicate = predicate;
    }

    public void setPreset(IProjectilePreset preset) {
        this.preset = preset;
    }

    public void setEffect(IProjectileEffect effect) {
        this.effect = effect;
    }

    public void setLifetime(int lifetime) {
        this.getDataManager().set(EntityEmberProjectile.lifetime, (Object)lifetime);
    }

    public Entity getShooter() {
        return this.shootingEntity;
    }

    protected void entityInit() {
    }

    protected void readEntityFromNBT(NBTTagCompound compound) {
        this.getDataManager().set(value, (Object)Float.valueOf(compound.getFloat("value")));
        this.getDataManager().setDirty(value);
        this.getDataManager().set(color, (Object)compound.getInteger("color"));
        this.getDataManager().setDirty(color);
    }

    protected void writeEntityToNBT(NBTTagCompound compound) {
        compound.setFloat("value", ((Float)this.getDataManager().get(value)).floatValue());
        compound.setInteger("color", ((Integer)this.getDataManager().get(color)).intValue());
    }

    public void onUpdate() {
        super.onUpdate();
        int lifetime = (Integer)this.getDataManager().get(EntityEmberProjectile.lifetime);
        this.getDataManager().set(EntityEmberProjectile.lifetime, (Object)(lifetime - 1));
        this.getDataManager().setDirty(EntityEmberProjectile.lifetime);
        World world = this.getEntityWorld();
        if (lifetime <= 0) {
            world.removeEntity((Entity)this);
            this.setDead();
        }
        if (!((Boolean)this.getDataManager().get(dead)).booleanValue()) {
            RayTraceResult hitEntity;
            Vec3d newPosVector;
            Vec3d currPosVec;
            RayTraceResult raytraceresult;
            this.getDataManager().set(value, (Object)Float.valueOf(((Float)this.getDataManager().get(value)).floatValue() - 0.025f));
            if (((Float)this.getDataManager().get(value)).floatValue() <= 0.0f) {
                world.removeEntity((Entity)this);
            }
            if ((raytraceresult = this.world.rayTraceBlocks(currPosVec = new Vec3d(this.posX, this.posY, this.posZ), newPosVector = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ), false, true, false)) != null && raytraceresult.typeOfHit != RayTraceResult.Type.MISS) {
                newPosVector = raytraceresult.hitVec;
            }
            if ((hitEntity = Misc.findEntityOnPath(world, this, this.shootingEntity, this.getEntityBoundingBox(), currPosVec, newPosVector, VALID_TARGETS)) != null) {
                newPosVector = hitEntity.hitVec;
                raytraceresult = hitEntity;
            }
            this.posX = newPosVector.x;
            this.posY = newPosVector.y;
            this.posZ = newPosVector.z;
            this.motionY += this.gravity;
            if (!world.isRemote && raytraceresult != null && raytraceresult.typeOfHit != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onHit(raytraceresult);
            }
            this.handleHoming(lifetime, world);
            if (world.isRemote) {
                Color particleColor = new Color((Integer)this.getDataManager().get(color), true);
                double deltaX = this.posX - this.prevPosX;
                double deltaY = this.posY - this.prevPosY;
                double deltaZ = this.posZ - this.prevPosZ;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 10.0);
                for (double i = 0.0; i < dist; i += 1.0) {
                    double coeff = i / dist;
                    ParticleUtil.spawnParticleGlow(world, (float)(this.prevPosX + (this.posX - this.prevPosX) * coeff), (float)(this.prevPosY + (this.posY - this.prevPosY) * coeff), (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * coeff), 0.0125f * (this.rand.nextFloat() - 0.5f), 0.0125f * (this.rand.nextFloat() - 0.5f), 0.0125f * (this.rand.nextFloat() - 0.5f), particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), ((Float)this.getDataManager().get(value)).floatValue() / 1.75f, 24);
                }
            }
            this.setPosition(this.posX, this.posY, this.posZ);
        } else {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
        }
    }

    private void handleHoming(int lifetime, World world) {
        if (this.homingTime > 0) {
            if (!this.isTargetInvalid(this.homingTarget)) {
                double targetX = this.homingTarget.posX;
                double targetY = this.homingTarget.posY + (double)(this.homingTarget.height / 2.0f);
                double targetZ = this.homingTarget.posZ;
                Vec3d targetVector = new Vec3d(targetX - this.posX, targetY - this.posY, targetZ - this.posZ);
                double length = targetVector.length();
                targetVector = targetVector.scale(0.3 / length);
                double weight = 0.0;
                if (length <= this.homingRange) {
                    weight = 0.9 * ((this.homingRange - length) / this.homingRange);
                }
                this.motionX = (0.9 - weight) * this.motionX + (0.1 + weight) * targetVector.x;
                this.motionY = (0.9 - weight) * this.motionY + (0.1 + weight) * targetVector.y;
                this.motionZ = (0.9 - weight) * this.motionZ + (0.1 + weight) * targetVector.z;
                --this.homingTime;
            } else if (lifetime % 5 == 0) {
                AxisAlignedBB homingAABB = new AxisAlignedBB(this.posX - this.homingRange, this.posY - this.homingRange, this.posZ - this.homingRange, this.posX + this.homingRange, this.posY + this.homingRange, this.posZ + this.homingRange);
                List entities = world.getEntitiesInAABBexcluding((Entity)this, homingAABB, this.homingPredicate);
                Entity badTarget = null;
                for (Entity entity : entities) {
                    long leastSignificantBits = entity.getUniqueID().getLeastSignificantBits() & 0xFFFFL;
                    if (leastSignificantBits % (long)this.homingModulo == (long)(this.homingIndex % this.homingModulo)) {
                        this.homingTarget = entity;
                    }
                    badTarget = entity;
                }
                if (this.homingTarget == null) {
                    this.homingTarget = badTarget;
                }
            }
        }
    }

    private boolean isTargetInvalid(Entity entity) {
        return entity == null || entity.isDead;
    }

    private void onHit(RayTraceResult raytraceresult) {
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSizedBurstFX(this.posX, this.posY, this.posZ, ((Float)this.getDataManager().get(value)).floatValue() / 1.75f, (Integer)this.getDataManager().get(color)));
        this.getDataManager().set(lifetime, (Object)20);
        this.getDataManager().setDirty(lifetime);
        this.getDataManager().set(dead, (Object)true);
        this.getDataManager().setDirty(dead);
        double aoeRadius = (double)((Float)this.getDataManager().get(value)).floatValue() * 0.125;
        if (this.effect != null) {
            this.effect.onHit(this.world, raytraceresult, this.preset);
        }
    }
}

