/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberSparkleFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.register.BlockRegister;

public class EntityEmberLight
extends Entity {
    BlockPos pos = new BlockPos(0, 0, 0);
    int lifetime = 160;
    public BlockPos dest = new BlockPos(0, 0, 0);

    public EntityEmberLight(World worldIn) {
        super(worldIn);
        this.setInvisible(true);
    }

    public void initCustom(double x, double y, double z, double vx, double vy, double vz) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.motionX = vx;
        this.motionY = vy;
        this.motionZ = vz;
    }

    protected void entityInit() {
    }

    public void onUpdate() {
        Vec3d newPosVector;
        Vec3d currPosVec;
        RayTraceResult raytraceresult;
        super.onUpdate();
        --this.lifetime;
        if (this.lifetime <= 0) {
            this.getEntityWorld().removeEntity((Entity)this);
            this.setDead();
        }
        if ((raytraceresult = this.world.rayTraceBlocks(currPosVec = new Vec3d(this.posX, this.posY, this.posZ), newPosVector = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ), false, true, false)) != null && raytraceresult.typeOfHit != RayTraceResult.Type.MISS) {
            newPosVector = raytraceresult.hitVec;
        }
        this.posX = newPosVector.x;
        this.posY = newPosVector.y;
        this.posZ = newPosVector.z;
        this.motionY += (double)-0.05f;
        if (!this.world.isRemote && raytraceresult != null && raytraceresult.typeOfHit == RayTraceResult.Type.BLOCK && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            EnumFacing side = raytraceresult.sideHit;
            BlockPos hitPos = raytraceresult.getBlockPos().offset(side);
            boolean hitGlimmer = false;
            if (this.getEntityWorld().isAirBlock(hitPos) || this.getEntityWorld().getBlockState(hitPos).getBlock().isReplaceable((IBlockAccess)this.getEntityWorld(), hitPos)) {
                this.getEntityWorld().setBlockState(hitPos, BlockRegister.GLOW.getDefaultState());
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSparkleFX((double)hitPos.getX() + 0.5, (double)hitPos.getY() + 0.5, (double)hitPos.getZ() + 0.5, false));
                hitGlimmer = true;
            }
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSparkleFX(this.posX, this.posY, this.posZ, !hitGlimmer));
            this.setDead();
        }
        if (this.getEntityWorld().isRemote) {
            for (double i = 0.0; i < 9.0; i += 1.0) {
                double coeff = i / 9.0;
                ParticleUtil.spawnParticleSpark(this.getEntityWorld(), (float)(this.prevPosX + (this.posX - this.prevPosX) * coeff), (float)(this.prevPosY + (this.posY - this.prevPosY) * coeff), (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * coeff), 0.1f * (this.rand.nextFloat() - 0.5f), 0.1f * (this.rand.nextFloat() - 0.5f), 0.1f * (this.rand.nextFloat() - 0.5f), 255.0f, 128.0f, 16.0f, 3.0f, 12);
            }
        }
    }

    protected void readEntityFromNBT(NBTTagCompound compound) {
    }

    protected void writeEntityToNBT(NBTTagCompound compound) {
    }
}

