/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.SoundManager;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.config.ConfigMob;
import teamroots.embers.damage.DamageEmber;
import teamroots.embers.entity.EntityEmberProjectile;
import teamroots.embers.register.ItemRegister;

public class EntityAncientGolem
extends EntityMob {
    public long lastPickaxeHit;

    public EntityAncientGolem(World worldIn) {
        super(worldIn);
        this.setSize(0.6f, 1.8f);
        this.experienceValue = 10;
    }

    protected void entityInit() {
        super.entityInit();
        this.isImmuneToFire = true;
    }

    protected void initEntityAI() {
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.46, true));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.46));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.46));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.applyEntityAI();
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(ConfigMob.EMBER_GOLEM.followRange);
        this.getEntityAttribute(SharedMonsterAttributes.KNOCKBACK_RESISTANCE).setBaseValue(ConfigMob.EMBER_GOLEM.knockbackResistance);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(ConfigMob.EMBER_GOLEM.movementSpeed);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(ConfigMob.EMBER_GOLEM.attackDamage);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(ConfigMob.EMBER_GOLEM.maxHealth);
    }

    protected void applyEntityAI() {
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void dropLoot(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.dropLoot(wasRecentlyHit, lootingModifier, source);
        if (this.world.getTotalWorldTime() - this.lastPickaxeHit < 400L || this.isPickaxeHit(source)) {
            this.dropItem(ItemRegister.GOLEMS_EYE, 1);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        this.rotationYaw = this.rotationYawHead;
        if (!this.isDead && this.getHealth() > 0.0f && this.ticksExisted % 100 == 0 && this.getAttackTarget() != null && !this.getEntityWorld().isRemote) {
            this.playSound(SoundManager.FIREBALL, 1.0f, 1.0f);
            EffectDamage effect = new EffectDamage(4.0f, DamageEmber.EMBER_DAMAGE_SOURCE_FACTORY, 1, 1.0);
            EntityEmberProjectile proj = new EntityEmberProjectile(this.getEntityWorld());
            proj.initCustom(this.posX, this.posY + 1.6, this.posZ, this.getLookVec().x * 0.5, this.getLookVec().y * 0.5, this.getLookVec().z * 0.5, 4.0, (Entity)this);
            proj.setEffect(effect);
            this.getEntityWorld().spawnEntity((Entity)proj);
        }
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        boolean result = super.attackEntityFrom(source, amount);
        if (result && this.isPickaxeHit(source)) {
            this.lastPickaxeHit = this.world.getTotalWorldTime();
        }
        return result;
    }

    public boolean isPickaxeHit(DamageSource source) {
        boolean isNormalAttack;
        Entity attacker = source.getImmediateSource();
        boolean bl = isNormalAttack = source.damageType.equals("player") || source.damageType.equals("mob");
        if (isNormalAttack && attacker instanceof EntityLivingBase) {
            ItemStack weapon = ((EntityLivingBase)attacker).getItemStackFromSlot(EntityEquipmentSlot.MAINHAND);
            return weapon.getItem().getToolClasses(weapon).contains("pickaxe");
        }
        return false;
    }

    public boolean attackEntityAsMob(Entity entityIn) {
        if (super.attackEntityAsMob(entityIn)) {
            this.playSound(SoundManager.ANCIENT_GOLEM_PUNCH, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    protected SoundEvent getDeathSound() {
        return SoundManager.ANCIENT_GOLEM_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundManager.ANCIENT_GOLEM_HURT;
    }

    protected void playStepSound(BlockPos pos, Block blockIn) {
        super.playStepSound(pos, blockIn);
        this.playSound(SoundManager.ANCIENT_GOLEM_STEP, 1.0f, 1.0f);
    }

    public ResourceLocation getLootTable() {
        return new ResourceLocation("embers", "entity/ancient_golem");
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setLong("lastPickaxeHit", this.lastPickaxeHit);
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.lastPickaxeHit = compound.getLong("lastPickaxeHit");
    }
}

