/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.jei.wrapper;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.IDrawable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.api.misc.ILiquidFuel;
import teamroots.embers.compat.jei.EmbersJEIPlugin;
import teamroots.embers.compat.jei.wrapper.FluidRecipeWrapper;

public class EngineRecipeWrapper
extends FluidRecipeWrapper {
    public static final int GEAR_X = 102;
    public static final int GEAR_Y = 6;
    ILiquidFuel fuelHandler;
    FluidStack input;
    public IDrawable gear;

    public EngineRecipeWrapper(ILiquidFuel fuelHandler, FluidStack input) {
        this.fuelHandler = fuelHandler;
        this.input = input;
        this.gear = EmbersJEIPlugin.HELPER.getGuiHelper().createDrawable(new ResourceLocation("embers", "textures/gui/jei_boiler.png"), 126, 0, 16, 16);
    }

    protected void drawGear(Minecraft minecraft, int gearX, int gearY) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)gearX, (float)gearY, (float)0.0f);
        GlStateManager.translate((float)8.0f, (float)8.0f, (float)0.0f);
        long l = System.currentTimeMillis() % 360000L;
        double speed = this.fuelHandler.getPower(this.input);
        double angle = (double)l / 50.0 * speed;
        GlStateManager.rotate((float)((float)angle), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translate((float)-8.0f, (float)-8.0f, (float)0.0f);
        this.gear.draw(minecraft, 0, 0);
        GlStateManager.popMatrix();
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX >= 102 && mouseY >= 6 && mouseX < 118 && mouseY < 22) {
            return this.getPowerTooltip();
        }
        return null;
    }

    private List<String> getPowerTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        this.addInfo(tooltip);
        return tooltip;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.drawGear(minecraft, 102, 6);
    }

    @Override
    public FluidStack getInput() {
        return this.input;
    }

    @Override
    public FluidStack getOutput() {
        return null;
    }

    @Override
    public void addInfo(List<String> tooltip) {
        this.fuelHandler.addInfo(this.input, tooltip);
    }
}

