/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.groovyscript;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.api.documentation.annotations.Comp;
import com.cleanroommc.groovyscript.api.documentation.annotations.Example;
import com.cleanroommc.groovyscript.api.documentation.annotations.MethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.Property;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderRegistrationMethod;
import com.cleanroommc.groovyscript.api.documentation.annotations.RegistryDescription;
import com.cleanroommc.groovyscript.helper.SimpleObjectStream;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import teamroots.embers.compat.groovyscript.GSPlugin;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@RegistryDescription(linkGenerator="embers")
public class Melter
extends VirtualizedRegistry<ItemMeltingRecipe> {
    @RecipeBuilderDescription(example={@Example(value=".input(item('minecraft:clay')).fluidOutput(fluid('water') * 100)"), @Example(value=".input(item('minecraft:gravel')).fluidOutput(fluid('lava') * 50, fluid('water') * 50)")})
    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    @GroovyBlacklist
    public void onReload() {
        RecipeRegistry.meltingRecipes.removeAll(this.removeScripted());
        RecipeRegistry.meltingRecipes.addAll(this.restoreFromBackup());
    }

    public void add(ItemMeltingRecipe recipe) {
        if (recipe != null) {
            this.addScripted(recipe);
            RecipeRegistry.meltingRecipes.add(recipe);
        }
    }

    public boolean remove(ItemMeltingRecipe recipe) {
        if (RecipeRegistry.meltingRecipes.removeIf(r -> r == recipe)) {
            this.addBackup(recipe);
            return true;
        }
        return false;
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, example={@Example(value="item('minecraft:redstone_block')")})
    public boolean removeByInput(IIngredient input) {
        return RecipeRegistry.meltingRecipes.removeIf(r -> {
            if (Arrays.stream(r.getInput().getMatchingStacks()).anyMatch((Predicate<ItemStack>)input)) {
                this.addBackup(r);
                return true;
            }
            return false;
        });
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, example={@Example(value="fluid('oil_soul')"), @Example(value="fluid('iron')", commented=true)})
    public boolean removeByOutput(IIngredient output) {
        return RecipeRegistry.meltingRecipes.removeIf(r -> {
            if (output.test(r.getFluid()) || output.test(r.getBonusOutput())) {
                this.addBackup(r);
                return true;
            }
            return false;
        });
    }

    @MethodDescription(type=MethodDescription.Type.QUERY)
    public SimpleObjectStream<ItemMeltingRecipe> streamRecipes() {
        return new SimpleObjectStream(RecipeRegistry.meltingRecipes).setRemover(this::remove);
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, priority=2000, example={@Example(commented=true)})
    public void removeAll() {
        RecipeRegistry.meltingRecipes.forEach(arg_0 -> ((Melter)this).addBackup(arg_0));
        RecipeRegistry.meltingRecipes.clear();
    }

    @Property.Properties(value={@Property(property="input", valid={@Comp(value="1")}), @Property(property="fluidOutput", valid={@Comp(value="1", type=Comp.Type.GTE), @Comp(value="2", type=Comp.Type.LTE)})})
    public static class RecipeBuilder
    extends AbstractRecipeBuilder<ItemMeltingRecipe> {
        public String getErrorMsg() {
            return "Error adding Embers Melter recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 1, 1, 0, 0);
            this.validateFluids(msg, 0, 0, 1, 2);
        }

        @RecipeBuilderRegistrationMethod
        @Nullable
        public ItemMeltingRecipe register() {
            if (!this.validate()) {
                return null;
            }
            ItemMeltingRecipe recipe = new ItemMeltingRecipe(((IIngredient)this.input.get(0)).toMcIngredient(), (FluidStack)this.fluidOutput.get(0));
            if (this.fluidOutput.size() == 2) {
                recipe.addBonusOutput((FluidStack)this.fluidOutput.get(1));
            }
            GSPlugin.instance.melter.add(recipe);
            return recipe;
        }
    }
}

