/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.crafttweaker;

import com.google.common.collect.Sets;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;
import teamroots.embers.recipe.BoreOutput;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.util.WeightedItemStack;

@ZenRegister
@ZenClass(value="mods.embers.EmberBore")
public class EmberBore {
    public static final String CLASS = "mods.embers.EmberBore";
    BoreOutput internal;

    @ZenGetter(value="dimensions")
    public Integer[] getDimensions() {
        return this.internal.dimensionIds.toArray(new Integer[this.internal.dimensionIds.size()]);
    }

    @ZenSetter(value="dimensions")
    public void setDimensions(Integer[] dimensions) {
        this.internal.dimensionIds = Sets.newHashSet((Object[])dimensions);
    }

    @ZenGetter(value="biomes")
    public String[] getBiomes() {
        return (String[])this.internal.biomeIds.stream().map(ResourceLocation::toString).toArray();
    }

    @ZenSetter(value="biomes")
    public void setBiomes(String[] biomes) {
        this.internal.biomeIds = Arrays.stream(biomes).map(ResourceLocation::new).collect(Collectors.toCollection(HashSet::new));
    }

    @ZenGetter(value="stacks")
    public crafttweaker.api.item.WeightedItemStack[] getStacks() {
        return (crafttweaker.api.item.WeightedItemStack[])this.internal.stacks.stream().map(stack -> new crafttweaker.api.item.WeightedItemStack(CraftTweakerMC.getIItemStack((ItemStack)stack.getStack()), (float)stack.itemWeight)).toArray();
    }

    @ZenMethod
    public void addOutput(crafttweaker.api.item.WeightedItemStack stack) {
        this.internal.stacks.add(new WeightedItemStack(CraftTweakerMC.getItemStack((IItemStack)stack.getStack()), (int)stack.getChance()));
    }

    @ZenMethod
    public void removeOutput(IItemStack stack) {
        ItemStack toRemove = CraftTweakerMC.getItemStack((IItemStack)stack);
        this.internal.stacks.removeIf(x -> x.getStack().isItemEqual(toRemove));
    }

    @ZenMethod
    public void clear() {
        this.internal.stacks.clear();
    }

    public EmberBore(BoreOutput internal) {
        this.internal = internal;
    }

    @ZenMethod
    public static EmberBore create(Integer[] dimensions, String[] biomes) {
        EmberBore emberBore = new EmberBore(new BoreOutput());
        emberBore.setDimensions(dimensions);
        emberBore.setBiomes(biomes);
        return emberBore;
    }

    @ZenMethod
    public static EmberBore getDefault() {
        return new EmberBore(RecipeRegistry.defaultBoreOutput);
    }
}

