/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.tileentity.TileEntityMiniBoiler;

public class BlockMiniBoiler
extends BlockTEBase {
    public static final PropertyDirection facing = PropertyDirection.create((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockMiniBoiler(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{facing});
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)facing)).getHorizontalIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)facing, (Comparable)EnumFacing.byHorizontalIndex((int)meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing facing = face.getAxis() != EnumFacing.Axis.Y ? face.getOpposite() : placer.getHorizontalFacing();
        return this.getDefaultState().withProperty((IProperty)BlockMiniBoiler.facing, (Comparable)facing);
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityMiniBoiler();
    }
}

