/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.api.block.IDial;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageTEUpdateRequest;
import teamroots.embers.tileentity.TileEntityItemRequisition;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class BlockItemRequisition
extends BlockTEBase
implements IDial {
    public static final PropertyDirection facing = PropertyDirection.create((String)"facing");

    public BlockItemRequisition(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{facing});
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)facing)).getIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)facing, (Comparable)EnumFacing.byIndex((int)meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)facing, (Comparable)face.getOpposite());
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == this.getFacing(state);
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.getValue((IProperty)facing);
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        ((TileEntityItemRequisition)world.getTileEntity(pos)).updateConnections();
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityItemRequisition();
    }

    @Override
    public List<String> getDisplayInfo(World world, BlockPos pos, IBlockState state) {
        ArrayList<String> text = new ArrayList<String>();
        TileEntity tileEntity = world.getTileEntity(pos);
        if (tileEntity instanceof TileEntityItemRequisition) {
            ((TileEntityItemRequisition)tileEntity).addDescription(text);
        }
        return text;
    }

    @Override
    public void updateTEData(World world, IBlockState state, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTEUpdateRequest(pos));
        }
    }

    @Override
    public String getDialType() {
        return "item_requisition";
    }

    public RayTraceResult collisionRayTrace(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        ArrayList<AxisAlignedBB> subBoxes = new ArrayList<AxisAlignedBB>();
        subBoxes.add(this.getBaseBox(state));
        if (world.getTileEntity(pos) instanceof TileEntityItemRequisition) {
            TileEntityItemRequisition pipe = (TileEntityItemRequisition)world.getTileEntity(pos);
            if (pipe.getInternalConnection(EnumFacing.UP) != EnumPipeConnection.NONE) {
                subBoxes.add(new AxisAlignedBB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625));
            }
            if (pipe.getInternalConnection(EnumFacing.DOWN) != EnumPipeConnection.NONE) {
                subBoxes.add(new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625));
            }
            if (pipe.getInternalConnection(EnumFacing.NORTH) != EnumPipeConnection.NONE) {
                subBoxes.add(new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.375));
            }
            if (pipe.getInternalConnection(EnumFacing.SOUTH) != EnumPipeConnection.NONE) {
                subBoxes.add(new AxisAlignedBB(0.375, 0.375, 0.625, 0.625, 0.625, 1.0));
            }
            if (pipe.getInternalConnection(EnumFacing.WEST) != EnumPipeConnection.NONE) {
                subBoxes.add(new AxisAlignedBB(0.0, 0.375, 0.375, 0.375, 0.625, 0.625));
            }
            if (pipe.getInternalConnection(EnumFacing.EAST) != EnumPipeConnection.NONE) {
                subBoxes.add(new AxisAlignedBB(0.625, 0.375, 0.375, 1.0, 0.625, 0.625));
            }
        }
        return Misc.raytraceMultiAABB(subBoxes, pos, start, end);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        double x1 = 0.25;
        double y1 = 0.25;
        double z1 = 0.25;
        double x2 = 0.75;
        double y2 = 0.75;
        double z2 = 0.75;
        EnumFacing facing = this.getFacing(state);
        if (source.getTileEntity(pos) instanceof TileEntityItemRequisition) {
            TileEntityItemRequisition pipe = (TileEntityItemRequisition)source.getTileEntity(pos);
            if (pipe.getInternalConnection(EnumFacing.UP) != EnumPipeConnection.NONE || facing == EnumFacing.UP) {
                y2 = 1.0;
            }
            if (pipe.getInternalConnection(EnumFacing.DOWN) != EnumPipeConnection.NONE || facing == EnumFacing.DOWN) {
                y1 = 0.0;
            }
            if (pipe.getInternalConnection(EnumFacing.NORTH) != EnumPipeConnection.NONE || facing == EnumFacing.NORTH) {
                z1 = 0.0;
            }
            if (pipe.getInternalConnection(EnumFacing.SOUTH) != EnumPipeConnection.NONE || facing == EnumFacing.SOUTH) {
                z2 = 1.0;
            }
            if (pipe.getInternalConnection(EnumFacing.WEST) != EnumPipeConnection.NONE || facing == EnumFacing.WEST) {
                x1 = 0.0;
            }
            if (pipe.getInternalConnection(EnumFacing.EAST) != EnumPipeConnection.NONE || facing == EnumFacing.EAST) {
                x2 = 1.0;
            }
        }
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public AxisAlignedBB getBaseBox(IBlockState state) {
        double x1 = 0.25;
        double y1 = 0.25;
        double z1 = 0.25;
        double x2 = 0.75;
        double y2 = 0.75;
        double z2 = 0.75;
        EnumFacing facing = this.getFacing(state);
        if (facing == EnumFacing.UP) {
            y2 = 1.0;
        }
        if (facing == EnumFacing.DOWN) {
            y1 = 0.0;
        }
        if (facing == EnumFacing.NORTH) {
            z1 = 0.0;
        }
        if (facing == EnumFacing.SOUTH) {
            z2 = 1.0;
        }
        if (facing == EnumFacing.WEST) {
            x1 = 0.0;
        }
        if (facing == EnumFacing.EAST) {
            x2 = 1.0;
        }
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }
}

