/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.tileentity.TileEntityInfernoForge;
import teamroots.embers.tileentity.TileEntityInfernoForgeOpening;

public class BlockInfernoForge
extends BlockTEBase {
    public static final AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    public static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 0.75, 1.0);
    public static final AxisAlignedBB AABB_TOP2 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    public static final AxisAlignedBB AABB_NULL = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final PropertyBool isTop = PropertyBool.create((String)"top");

    public BlockInfernoForge(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean b) {
        if (((Boolean)state.getValue((IProperty)isTop)).booleanValue()) {
            TileEntity t = worldIn.getTileEntity(pos);
            if (t instanceof TileEntityInfernoForgeOpening) {
                if (((TileEntityInfernoForgeOpening)t).openAmount > 0.0f) {
                    BlockInfernoForge.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_NULL);
                } else {
                    BlockInfernoForge.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_TOP);
                    BlockInfernoForge.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_TOP2);
                }
            }
        } else {
            BlockInfernoForge.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BASE);
        }
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        if (meta == 0) {
            return new TileEntityInfernoForge();
        }
        if (meta == 1) {
            return new TileEntityInfernoForgeOpening();
        }
        return null;
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{isTop});
    }

    public int getMetaFromState(IBlockState state) {
        boolean top = (Boolean)state.getValue((IProperty)isTop);
        return top ? 1 : 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)isTop, (Comparable)Boolean.valueOf(meta == 1));
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        if (this.isReplaceable(world, pos.east()) && this.isReplaceable(world, pos.up()) && this.isReplaceable(world, pos.west()) && this.isReplaceable(world, pos.north()) && this.isReplaceable(world, pos.south()) && this.isReplaceable(world, pos.east().north()) && this.isReplaceable(world, pos.east().south()) && this.isReplaceable(world, pos.west().north()) && this.isReplaceable(world, pos.west().south()) && this.isReplaceable(world, pos.east().up()) && this.isReplaceable(world, pos.west().up()) && this.isReplaceable(world, pos.north().up()) && this.isReplaceable(world, pos.south().up()) && this.isReplaceable(world, pos.east().north().up()) && this.isReplaceable(world, pos.east().south().up()) && this.isReplaceable(world, pos.west().north().up()) && this.isReplaceable(world, pos.west().south().up())) {
            return super.canPlaceBlockAt(world, pos);
        }
        return false;
    }

    private boolean isReplaceable(World world, BlockPos pos) {
        return world.getBlockState(pos).getBlock().isReplaceable((IBlockAccess)world, pos);
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.getValue((IProperty)isTop)).booleanValue()) {
            world.setBlockState(pos.up(), BlockRegister.INFERNO_FORGE.getStateFromMeta(1));
            world.setBlockState(pos.north(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(0));
            world.setBlockState(pos.north().west(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(1));
            world.setBlockState(pos.west(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(2));
            world.setBlockState(pos.south().west(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(3));
            world.setBlockState(pos.south(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(4));
            world.setBlockState(pos.south().east(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(5));
            world.setBlockState(pos.east(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(6));
            world.setBlockState(pos.north().east(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(7));
            world.setBlockState(pos.north().up(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(8));
            world.setBlockState(pos.north().west().up(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(9));
            world.setBlockState(pos.west().up(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(10));
            world.setBlockState(pos.south().west().up(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(11));
            world.setBlockState(pos.south().up(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(12));
            world.setBlockState(pos.south().east().up(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(13));
            world.setBlockState(pos.east().up(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(14));
            world.setBlockState(pos.north().east().up(), BlockRegister.INFERNO_FORGE_EDGE.getStateFromMeta(15));
        }
    }

    public void removeEdge(World world, BlockPos pos) {
        if (world.getBlockState(pos).getBlock() == BlockRegister.INFERNO_FORGE_EDGE) {
            world.setBlockToAir(pos);
            world.notifyBlockUpdate(pos, BlockRegister.INFERNO_FORGE_EDGE.getDefaultState(), Blocks.AIR.getDefaultState(), 8);
        }
        if (world.getBlockState(pos).getBlock() == this) {
            world.setBlockToAir(pos);
            world.setTileEntity(pos, null);
            world.notifyBlockUpdate(pos, this.getDefaultState().withProperty((IProperty)isTop, (Comparable)Boolean.valueOf(true)), Blocks.AIR.getDefaultState(), 8);
        }
    }

    public void cleanEdges(World world, BlockPos pos) {
        this.removeEdge(world, pos.north());
        this.removeEdge(world, pos.north().west());
        this.removeEdge(world, pos.west());
        this.removeEdge(world, pos.south().west());
        this.removeEdge(world, pos.south());
        this.removeEdge(world, pos.south().east());
        this.removeEdge(world, pos.east());
        this.removeEdge(world, pos.north().east());
        this.removeEdge(world, pos.north().up());
        this.removeEdge(world, pos.north().west().up());
        this.removeEdge(world, pos.west().up());
        this.removeEdge(world, pos.south().west().up());
        this.removeEdge(world, pos.south().up());
        this.removeEdge(world, pos.south().east().up());
        this.removeEdge(world, pos.east().up());
        this.removeEdge(world, pos.north().east().up());
        this.removeEdge(world, pos.up());
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (state.getBlock() == this && !((Boolean)state.getValue((IProperty)isTop)).booleanValue()) {
            drops.add(new ItemStack((Block)this, 1));
        }
        return drops;
    }
}

