/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityFieldChart;

public class BlockFieldChart
extends BlockTEBase {
    public static final PropertyInteger state = PropertyInteger.create((String)"state", (int)0, (int)9);
    public static final AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_BASE;
    }

    public BlockFieldChart(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 8) {
            list.add(new ItemStack((Block)this, 1));
        }
        return list;
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{state});
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)BlockFieldChart.state);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)state, (Comparable)Integer.valueOf(meta));
    }

    public void breakBlockSafe(World world, BlockPos pos, EntityPlayer player) {
        if (world.getTileEntity(pos) instanceof ITileEntityBase) {
            ((ITileEntityBase)world.getTileEntity(pos)).breakBlock(world, pos, world.getBlockState(pos), player);
        }
        if (world.getBlockState(pos).getBlock() == this && (Integer)world.getBlockState(pos).getValue((IProperty)state) == 8 && !world.isRemote && !player.capabilities.isCreativeMode) {
            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        world.setBlockToAir(pos);
    }

    @Override
    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 9) {
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.south(2), player);
            this.breakBlockSafe(world, pos.east(), player);
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.east().south(), player);
            this.breakBlockSafe(world, pos.west().south(), player);
            this.breakBlockSafe(world, pos.east().south(2), player);
            this.breakBlockSafe(world, pos.west().south(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 1) {
            this.breakBlockSafe(world, pos.east(), player);
            this.breakBlockSafe(world, pos.east(2), player);
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.south(2), player);
            this.breakBlockSafe(world, pos.east().south(), player);
            this.breakBlockSafe(world, pos.east(2).south(), player);
            this.breakBlockSafe(world, pos.east().south(2), player);
            this.breakBlockSafe(world, pos.east(2).south(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 2) {
            this.breakBlockSafe(world, pos.east(), player);
            this.breakBlockSafe(world, pos.east(2), player);
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.north().east(), player);
            this.breakBlockSafe(world, pos.south().east(), player);
            this.breakBlockSafe(world, pos.north().east(2), player);
            this.breakBlockSafe(world, pos.south().east(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 3) {
            this.breakBlockSafe(world, pos.east(), player);
            this.breakBlockSafe(world, pos.east(2), player);
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.north(2), player);
            this.breakBlockSafe(world, pos.east().north(), player);
            this.breakBlockSafe(world, pos.east(2).north(), player);
            this.breakBlockSafe(world, pos.east().north(2), player);
            this.breakBlockSafe(world, pos.east(2).north(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 4) {
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.north(2), player);
            this.breakBlockSafe(world, pos.east(), player);
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.east().north(), player);
            this.breakBlockSafe(world, pos.west().north(), player);
            this.breakBlockSafe(world, pos.east().north(2), player);
            this.breakBlockSafe(world, pos.west().north(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 5) {
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.west(2), player);
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.north(2), player);
            this.breakBlockSafe(world, pos.west().north(), player);
            this.breakBlockSafe(world, pos.west(2).north(), player);
            this.breakBlockSafe(world, pos.west().north(2), player);
            this.breakBlockSafe(world, pos.west(2).north(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 6) {
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.west(2), player);
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.north().west(), player);
            this.breakBlockSafe(world, pos.south().west(), player);
            this.breakBlockSafe(world, pos.north().west(2), player);
            this.breakBlockSafe(world, pos.south().west(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 7) {
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.west(2), player);
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.south(2), player);
            this.breakBlockSafe(world, pos.west().south(), player);
            this.breakBlockSafe(world, pos.west(2).south(), player);
            this.breakBlockSafe(world, pos.west().south(2), player);
            this.breakBlockSafe(world, pos.west(2).south(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 8) {
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.west().south(), player);
            this.breakBlockSafe(world, pos.west().north(), player);
            this.breakBlockSafe(world, pos.south().east(), player);
            this.breakBlockSafe(world, pos.north().east(), player);
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.east(), player);
        }
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        if (this.isReplaceable(world, pos.east()) && this.isReplaceable(world, pos.west()) && this.isReplaceable(world, pos.north()) && this.isReplaceable(world, pos.south()) && this.isReplaceable(world, pos.east().north()) && this.isReplaceable(world, pos.east().south()) && this.isReplaceable(world, pos.west().north()) && this.isReplaceable(world, pos.west().south())) {
            return super.canPlaceBlockAt(world, pos);
        }
        return false;
    }

    private boolean isReplaceable(World world, BlockPos pos) {
        return world.getBlockState(pos).getBlock().isReplaceable((IBlockAccess)world, pos);
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if ((Integer)state.getValue((IProperty)BlockFieldChart.state) == 0) {
            world.setBlockState(pos, this.getStateFromMeta(8));
            world.setBlockState(pos.north(), this.getStateFromMeta(9));
            world.setBlockState(pos.north().west(), this.getStateFromMeta(1));
            world.setBlockState(pos.west(), this.getStateFromMeta(2));
            world.setBlockState(pos.south().west(), this.getStateFromMeta(3));
            world.setBlockState(pos.south(), this.getStateFromMeta(4));
            world.setBlockState(pos.south().east(), this.getStateFromMeta(5));
            world.setBlockState(pos.east(), this.getStateFromMeta(6));
            world.setBlockState(pos.north().east(), this.getStateFromMeta(7));
        }
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        if (meta == 8) {
            return new TileEntityFieldChart();
        }
        return null;
    }
}

