/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.Embers;
import teamroots.embers.block.IBlock;
import teamroots.embers.block.IModeledBlock;

public class BlockDoubleSlabBase
extends BlockSlab
implements IModeledBlock,
IBlock {
    public Item itemBlock = null;
    private Block slab;
    public boolean isOpaqueCube = true;
    public boolean isFullCube = true;
    public static AxisAlignedBB FULL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public BlockRenderLayer layer = BlockRenderLayer.SOLID;

    public BlockDoubleSlabBase(Material material, String name, boolean addToTab) {
        super(material);
        this.setTranslationKey(name);
        this.setRegistryName("embers:" + name);
        if (addToTab) {
            this.setCreativeTab(Embers.tab);
        }
        this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    public void getSubBlocks(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    public BlockDoubleSlabBase setIsOpaqueCube(boolean b) {
        this.isOpaqueCube = b;
        return this;
    }

    public void setSlab(Block slab) {
        this.slab = slab;
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack(Item.getItemFromBlock((Block)this.slab), 1));
        drops.add(new ItemStack(Item.getItemFromBlock((Block)this.slab), 1));
        return drops;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return this.isOpaqueCube;
    }

    public BlockDoubleSlabBase setIsFullCube(boolean b) {
        this.isFullCube = b;
        return this;
    }

    public boolean isFullCube(IBlockState state) {
        return this.isFullCube;
    }

    public BlockDoubleSlabBase setHarvestProperties(String toolType, int level) {
        super.setHarvestLevel(toolType, level);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean isHalfSlab(IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.getItemFromBlock((Block)this.slab));
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState iblockstate = this.getDefaultState();
        if (!this.isDouble()) {
            iblockstate = iblockstate.withProperty((IProperty)HALF, (Comparable)(meta == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        return FULL_AABB;
    }

    public int getMetaFromState(IBlockState state) {
        return state.getValue((IProperty)HALF) == BlockSlab.EnumBlockHalf.BOTTOM ? 0 : 1;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public boolean isDouble() {
        return false;
    }

    public String getTranslationKey(int meta) {
        return null;
    }

    public IProperty getVariantProperty() {
        return HALF;
    }

    public Comparable<?> getTypeForItem(ItemStack stack) {
        return 0;
    }

    @Override
    public Item getItemBlock() {
        return this.itemBlock;
    }
}

