/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.tileentity.TileEntityDawnstoneAnvil;

public class BlockDawnstoneAnvil
extends BlockTEBase {
    public static AxisAlignedBB AABB_Z = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 0.75);
    public static AxisAlignedBB AABB_X = new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 1.0);
    public static final PropertyDirection facing = PropertyDirection.create((String)"facing", Arrays.asList(EnumFacing.HORIZONTALS));

    public BlockDawnstoneAnvil(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockDawnstoneAnvil.facing);
        if (facing.getAxis() == EnumFacing.Axis.Z) {
            return AABB_X;
        }
        return AABB_Z;
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{facing});
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)facing)).getHorizontalIndex();
    }

    public boolean canPlaceBlockOnSide(World world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP || side == EnumFacing.DOWN;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.getDefaultState();
        state = state.withProperty((IProperty)facing, (Comparable)placer.getHorizontalFacing());
        return state;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)facing, (Comparable)EnumFacing.byHorizontalIndex((int)meta));
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityDawnstoneAnvil();
    }
}

