/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.item.block.ItemBlockCell;
import teamroots.embers.tileentity.TileEntityCopperCell;

public class BlockCopperCell
extends BlockTEBase {
    public BlockCopperCell(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
        this.itemBlock = (Item)new ItemBlockCell(this).setRegistryName(this.getRegistryName());
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, player, stack);
        if (stack.hasTagCompound()) {
            TileEntityCopperCell tile = (TileEntityCopperCell)this.createNewTileEntity(world, this.getMetaFromState(state));
            world.setTileEntity(pos, (TileEntity)tile);
            if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
                IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
                tile.capability.setEmberCapacity(capability.getEmberCapacity());
                tile.capability.setEmber(capability.getEmber());
            }
            tile.markDirty();
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        return items;
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityCopperCell();
    }
}

