/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.api.block.IDial;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageTEUpdateRequest;
import teamroots.embers.tileentity.TileEntityBaseGauge;

public abstract class BlockBaseGauge
extends BlockTEBase
implements IDial {
    public static final PropertyDirection facing = PropertyDirection.create((String)"facing");

    public BlockBaseGauge(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public BlockBaseGauge(Material material) {
        super(material);
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{facing});
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)facing)).getIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)facing, (Comparable)EnumFacing.byIndex((int)meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)facing, (Comparable)face);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.isAirBlock(pos.offset((EnumFacing)state.getValue((IProperty)facing), -1))) {
            world.setBlockToAir(pos);
            this.dropBlockAsItem(world, pos, state, 0);
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.getValue((IProperty)facing)) {
            case UP: {
                return new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.125, 0.6875);
            }
            case DOWN: {
                return new AxisAlignedBB(0.3125, 0.875, 0.3125, 0.6875, 1.0, 0.6875);
            }
            case NORTH: {
                return new AxisAlignedBB(0.3125, 0.3125, 0.875, 0.6875, 0.6875, 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.125);
            }
            case WEST: {
                return new AxisAlignedBB(0.875, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
            }
            case EAST: {
                return new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.125, 0.6875, 0.6875);
            }
        }
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
    }

    @Override
    public List<String> getDisplayInfo(World world, BlockPos pos, IBlockState state) {
        ArrayList<String> text = new ArrayList<String>();
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockBaseGauge.facing);
        TileEntity tileEntity = world.getTileEntity(pos.offset(facing.getOpposite()));
        if (tileEntity != null) {
            this.getTEData(facing, text, tileEntity);
            if (tileEntity instanceof IExtraDialInformation) {
                ((IExtraDialInformation)tileEntity).addDialInformation(facing, text, this.getDialType());
            }
        }
        return text;
    }

    protected abstract void getTEData(EnumFacing var1, ArrayList<String> var2, TileEntity var3);

    @Override
    public void updateTEData(World world, IBlockState state, BlockPos pos) {
        BlockPos tilePos = pos.offset(((EnumFacing)state.getValue((IProperty)facing)).getOpposite());
        TileEntity tile = world.getTileEntity(tilePos);
        if (tile != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTEUpdateRequest(tilePos));
        }
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.getTileEntity(pos);
        if (tile instanceof TileEntityBaseGauge) {
            return ((TileEntityBaseGauge)tile).getComparatorValue();
        }
        return 0;
    }
}

