/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import teamroots.embers.Embers;
import teamroots.embers.block.IBlock;
import teamroots.embers.block.IModeledBlock;

public class BlockBase
extends Block
implements IModeledBlock,
IBlock {
    public Item itemBlock = null;
    public boolean isOpaqueCube = true;
    public boolean isFullCube = true;
    public boolean isBeaconBase = false;
    public BlockRenderLayer layer = BlockRenderLayer.SOLID;

    public BlockBase(Material material, String name, boolean addToTab) {
        super(material);
        this.setTranslationKey(name);
        this.setRegistryName("embers:" + name);
        if (addToTab) {
            this.setCreativeTab(Embers.tab);
        }
        this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    public BlockBase(Material material) {
        super(material);
    }

    public BlockBase setIsOpaqueCube(boolean b) {
        this.isOpaqueCube = b;
        return this;
    }

    public BlockBase setBeaconBase(boolean b) {
        this.isBeaconBase = b;
        return this;
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        return this.isBeaconBase;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return this.isOpaqueCube;
    }

    public BlockBase setIsFullCube(boolean b) {
        this.isFullCube = b;
        return this;
    }

    public boolean isFullCube(IBlockState state) {
        return this.isFullCube;
    }

    public boolean isFullBlock(IBlockState state) {
        return this.isFullCube;
    }

    public BlockBase setHarvestProperties(String toolType, int level) {
        super.setHarvestLevel(toolType, level);
        return this;
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
    }

    @Override
    public Item getItemBlock() {
        return this.itemBlock;
    }
}

