/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockBase;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.tileentity.ITileEntityBase;

public class BlockAdvancedEdge
extends BlockBase {
    public static final PropertyInteger state = PropertyInteger.create((String)"state", (int)0, (int)9);
    public static final AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_BASE;
    }

    public BlockAdvancedEdge(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public void getSubBlocks(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{state});
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)BlockAdvancedEdge.state);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)state, (Comparable)Integer.valueOf(meta));
    }

    public void breakBlockSafe(World world, BlockPos pos, EntityPlayer player) {
        if (world.getTileEntity(pos) instanceof ITileEntityBase) {
            ((ITileEntityBase)world.getTileEntity(pos)).breakBlock(world, pos, world.getBlockState(pos), player);
        }
        world.setBlockToAir(pos);
    }

    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        boolean drop = !player.capabilities.isCreativeMode;
        this.yeetBlocks(world, pos, player, drop);
    }

    public void onExplosionDestroy(World world, BlockPos pos, Explosion explosion) {
        this.yeetBlocks(world, pos, null, true);
    }

    public void yeetBlocks(World world, BlockPos pos, EntityPlayer player, boolean drop) {
        IBlockState state;
        if (!world.isRemote && drop) {
            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack(BlockRegister.CRYSTAL_CELL, 1, 0)));
        }
        if ((Integer)(state = world.getBlockState(pos)).getValue((IProperty)BlockAdvancedEdge.state) == 9) {
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.south(2), player);
            this.breakBlockSafe(world, pos.east(), player);
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.east().south(), player);
            this.breakBlockSafe(world, pos.west().south(), player);
            this.breakBlockSafe(world, pos.east().south(2), player);
            this.breakBlockSafe(world, pos.west().south(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockAdvancedEdge.state) == 1) {
            this.breakBlockSafe(world, pos.east(), player);
            this.breakBlockSafe(world, pos.east(2), player);
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.south(2), player);
            this.breakBlockSafe(world, pos.east().south(), player);
            this.breakBlockSafe(world, pos.east(2).south(), player);
            this.breakBlockSafe(world, pos.east().south(2), player);
            this.breakBlockSafe(world, pos.east(2).south(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockAdvancedEdge.state) == 2) {
            this.breakBlockSafe(world, pos.east(), player);
            this.breakBlockSafe(world, pos.east(2), player);
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.north().east(), player);
            this.breakBlockSafe(world, pos.south().east(), player);
            this.breakBlockSafe(world, pos.north().east(2), player);
            this.breakBlockSafe(world, pos.south().east(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockAdvancedEdge.state) == 3) {
            this.breakBlockSafe(world, pos.east(), player);
            this.breakBlockSafe(world, pos.east(2), player);
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.north(2), player);
            this.breakBlockSafe(world, pos.east().north(), player);
            this.breakBlockSafe(world, pos.east(2).north(), player);
            this.breakBlockSafe(world, pos.east().north(2), player);
            this.breakBlockSafe(world, pos.east(2).north(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockAdvancedEdge.state) == 4) {
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.north(2), player);
            this.breakBlockSafe(world, pos.east(), player);
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.east().north(), player);
            this.breakBlockSafe(world, pos.west().north(), player);
            this.breakBlockSafe(world, pos.east().north(2), player);
            this.breakBlockSafe(world, pos.west().north(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockAdvancedEdge.state) == 5) {
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.west(2), player);
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.north(2), player);
            this.breakBlockSafe(world, pos.west().north(), player);
            this.breakBlockSafe(world, pos.west(2).north(), player);
            this.breakBlockSafe(world, pos.west().north(2), player);
            this.breakBlockSafe(world, pos.west(2).north(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockAdvancedEdge.state) == 6) {
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.west(2), player);
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.north().west(), player);
            this.breakBlockSafe(world, pos.south().west(), player);
            this.breakBlockSafe(world, pos.north().west(2), player);
            this.breakBlockSafe(world, pos.south().west(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockAdvancedEdge.state) == 7) {
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.west(2), player);
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.south(2), player);
            this.breakBlockSafe(world, pos.west().south(), player);
            this.breakBlockSafe(world, pos.west(2).south(), player);
            this.breakBlockSafe(world, pos.west().south(2), player);
            this.breakBlockSafe(world, pos.west(2).south(2), player);
        }
        if ((Integer)state.getValue((IProperty)BlockAdvancedEdge.state) == 8) {
            this.breakBlockSafe(world, pos.west(), player);
            this.breakBlockSafe(world, pos.south(), player);
            this.breakBlockSafe(world, pos.west().south(), player);
            this.breakBlockSafe(world, pos.west().north(), player);
            this.breakBlockSafe(world, pos.south().east(), player);
            this.breakBlockSafe(world, pos.north().east(), player);
            this.breakBlockSafe(world, pos.north(), player);
            this.breakBlockSafe(world, pos.east(), player);
        }
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        return world.isAirBlock(pos.east()) && world.isAirBlock(pos.west()) && world.isAirBlock(pos.north()) && world.isAirBlock(pos.south()) && world.isAirBlock(pos.east().north()) && world.isAirBlock(pos.east().south()) && world.isAirBlock(pos.west().north()) && world.isAirBlock(pos.west().south());
    }

    @Override
    public Item getItemBlock() {
        return null;
    }
}

