/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.tile.IOrderSource;
import teamroots.embers.util.FilterUtil;

public class OrderStack {
    private BlockPos pos;
    private IFilter filter;
    private int size;

    public OrderStack(BlockPos pos, IFilter filter, int size) {
        this.pos = pos;
        this.filter = filter;
        this.size = size;
    }

    public OrderStack(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IOrderSource getSource(World world) {
        TileEntity tile = world.getTileEntity(this.pos);
        if (tile instanceof IOrderSource) {
            return (IOrderSource)tile;
        }
        return null;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public int getSize() {
        return this.size;
    }

    public boolean acceptsItem(World world, ItemStack stack) {
        IItemHandler itemHandler;
        IOrderSource source = this.getSource(world);
        if (source != null && (itemHandler = source.getItemHandler()) != null) {
            return this.filter.acceptsItem(stack, itemHandler);
        }
        return false;
    }

    public void deplete(int n) {
        this.size -= n;
    }

    public void increment(int n) {
        this.size += n;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.setInteger("x", this.pos.getX());
        tag.setInteger("y", this.pos.getY());
        tag.setInteger("z", this.pos.getZ());
        tag.setTag("filter", (NBTBase)this.filter.writeToNBT(new NBTTagCompound()));
        tag.setInteger("size", this.size);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.pos = new BlockPos(tag.getInteger("x"), tag.getInteger("y"), tag.getInteger("z"));
        this.filter = FilterUtil.deserializeFilter(tag.getCompoundTag("filter"));
        this.size = tag.getInteger("size");
    }

    public void reset(IFilter filter, int size) {
        this.filter = filter;
        this.size = size;
    }
}

