/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.projectile;

import com.google.common.base.Predicate;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import teamroots.embers.api.projectile.IProjectileEffect;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.entity.EntityEmberProjectile;

public class ProjectileFireball
implements IProjectilePreset {
    Vec3d pos;
    Vec3d velocity;
    IProjectileEffect effect;
    double size;
    int lifetime;
    Entity shooter;
    EntityEmberProjectile entity;
    Color color = new Color(255, 64, 16);
    double gravity;
    int homingTime;
    double homingRange;
    int homingIndex;
    int homingModulo;
    Predicate<Entity> homingPredicate;

    public ProjectileFireball(Entity shooter, Vec3d pos, Vec3d velocity, double size, int lifetime, IProjectileEffect effect) {
        this.pos = pos;
        this.velocity = velocity;
        this.effect = effect;
        this.size = size;
        this.lifetime = lifetime;
        this.shooter = shooter;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public Vec3d getPos() {
        return this.pos;
    }

    @Override
    public void setPos(Vec3d pos) {
        this.pos = pos;
    }

    @Override
    public Vec3d getVelocity() {
        return this.velocity;
    }

    @Override
    public void setVelocity(Vec3d velocity) {
        this.velocity = velocity;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    public double getGravity() {
        return this.gravity;
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    @Override
    public IProjectileEffect getEffect() {
        return this.effect;
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    @Nullable
    public Entity getShooter() {
        return this.shooter;
    }

    @Override
    public void setEffect(IProjectileEffect effect) {
        this.effect = effect;
    }

    public void setHoming(int time, double range, int index, int modulo, Predicate<Entity> predicate) {
        this.homingTime = time;
        this.homingRange = range;
        this.homingIndex = index;
        this.homingModulo = modulo;
        this.homingPredicate = predicate;
    }

    @Override
    public void shoot(World world) {
        this.entity = new EntityEmberProjectile(world);
        this.entity.initCustom(this.pos.x, this.pos.y, this.pos.z, this.velocity.x, this.velocity.y, this.velocity.z, this.size, this.shooter);
        this.entity.setGravity(this.gravity);
        this.entity.setEffect(this.effect);
        this.entity.setPreset(this);
        this.entity.setLifetime(this.lifetime);
        this.entity.setColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
        this.entity.setHoming(this.homingTime, this.homingRange, this.homingIndex, this.homingModulo, this.homingPredicate);
        world.spawnEntity((Entity)this.entity);
    }
}

