/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.itemmod;

import com.google.common.collect.Multimap;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;

public class ModifierBase {
    public EnumType type;
    public String name;
    public double cost;
    public boolean countTowardsTotalLevel;
    public boolean canRemove = true;
    public boolean shouldRenderTooltip = true;

    public ModifierBase(EnumType type, String name, double cost, boolean levelCounts) {
        this.type = type;
        this.name = name;
        this.cost = cost;
        this.countTowardsTotalLevel = levelCounts;
    }

    public boolean canApplyTo(ItemStack stack) {
        return this.canApplyToType(stack, this.type);
    }

    protected boolean canApplyToType(ItemStack stack, EnumType type) {
        Item item = stack.getItem();
        switch (type) {
            case ALL: {
                return true;
            }
            case TOOL_OR_ARMOR: {
                if (item instanceof ItemArmor) {
                    return true;
                }
            }
            case TOOL: {
                return !item.getToolClasses(stack).isEmpty() || item instanceof ItemSword || item instanceof ItemHoe || item instanceof ItemTool || this.isSecretlyAWeapon(stack);
            }
            case ARMOR: {
                return item instanceof ItemArmor;
            }
            case HELMET: {
                return item instanceof ItemArmor && ((ItemArmor)item).armorType == EntityEquipmentSlot.HEAD;
            }
            case CHESTPLATE: {
                return item instanceof ItemArmor && ((ItemArmor)item).armorType == EntityEquipmentSlot.CHEST;
            }
            case LEGGINGS: {
                return item instanceof ItemArmor && ((ItemArmor)item).armorType == EntityEquipmentSlot.LEGS;
            }
            case BOOTS: {
                return item instanceof ItemArmor && ((ItemArmor)item).armorType == EntityEquipmentSlot.FEET;
            }
        }
        return false;
    }

    private boolean isSecretlyAWeapon(ItemStack stack) {
        Multimap attributeMap = stack.getAttributeModifiers(EntityEquipmentSlot.MAINHAND);
        return !attributeMap.isEmpty();
    }

    public void onApply(ItemStack stack) {
    }

    public void onRemove(ItemStack stack) {
    }

    public static enum EnumType {
        ALL,
        TOOL_OR_ARMOR,
        TOOL,
        PROJECTILE,
        ARMOR,
        HELMET,
        CHESTPLATE,
        LEGGINGS,
        BOOTS;

    }
}

