/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.filter;

import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import teamroots.embers.api.filter.IFilter;

public class FilterItem
implements IFilter {
    public static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("embers", "item");
    private ItemStack filterItem = ItemStack.EMPTY;

    public FilterItem(ItemStack filterItem) {
        this.filterItem = filterItem;
    }

    public FilterItem(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    @Override
    public ResourceLocation getType() {
        return RESOURCE_LOCATION;
    }

    @Override
    public boolean acceptsItem(ItemStack stack) {
        return this.filterItem.getItem() == stack.getItem() && this.filterItem.getItemDamage() == stack.getItemDamage();
    }

    @Override
    public String formatFilter() {
        return I18n.format((String)"embers.filter.strict", (Object[])new Object[]{this.filterItem.getDisplayName()});
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.setString("type", this.getType().toString());
        tag.setTag("filterStack", (NBTBase)this.filterItem.serializeNBT());
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.filterItem = new ItemStack(tag.getCompoundTag("filterStack"));
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterItem) {
            return this.equals((FilterItem)obj);
        }
        return super.equals(obj);
    }

    private boolean equals(FilterItem other) {
        return ItemStack.areItemStacksEqual((ItemStack)this.filterItem, (ItemStack)other.filterItem);
    }
}

